---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-プロパティをメソッドに変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ReplacePropertyWithMethods/ReplacePropertyWithMethodsCodeRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/ReplacePropertyWithMethods/IReplacePropertyWithMethodsService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロパティをGetXxx()/SetXxx()メソッドに変換 | E-01 (35-36行目 GetPrefix/SetPrefix), E-03 (57行目) | ○ |
| C-02 | IReplacePropertyWithMethodsServiceインターフェース | E-02 (14-33行目) | ○ |
| C-03 | GetPropertyDeclarationAsyncでプロパティ宣言取得 | E-02 (16行目), E-01 (45行目) | ○ |
| C-04 | アクセサ数でメッセージを切り替え | E-01 (55-61行目) | ○ |
| C-05 | SymbolFinderで全参照を検索 | E-01 (85行目) | ○ |
| C-06 | バッキングフィールドマッピングを作成 | E-01 (115-126行目) | ○ |
| C-07 | GetBackingFieldでフィールド取得・生成 | E-01 (153-178行目) | ○ |
| C-08 | 自動プロパティの場合は新規フィールド生成 | E-01 (168-177行目) | ○ |
| C-09 | フィールド名をcamelCaseに変換 | E-01 (168-170行目 ToCamelCase) | ○ |
| C-10 | 暗黙的参照は警告アノテーション追加 | E-01 (260-264行目) | ○ |
| C-11 | 更新不可位置の参照は警告追加 | E-01 (266-271行目, 285-290行目) | ○ |
| C-12 | ReplaceReferenceAsyncで参照更新 | E-02 (18-23行目), E-01 (276-280行目) | ○ |
| C-13 | GetReplacementMembersAsyncでメソッド生成 | E-02 (25-31行目), E-01 (370-375行目) | ○ |
| C-14 | インターフェースプロパティは抽象メンバーとして生成 | E-01 (379-384行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#固有の実装（CSharpReplacePropertyWithMethodsService）が存在するか確認
- [ ] VB固有の実装（VisualBasicReplacePropertyWithMethodsService）が存在するか確認
- [ ] VBではバッキングフィールドが既にCanBeReferencedByNameである点の処理確認
