---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-if文の分割・結合

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/SplitOrMergeIfStatements/AbstractSplitIfStatementCodeRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/SplitOrMergeIfStatements/AbstractMergeIfStatementsCodeRefactoringProvider.cs`
- E-03: `src/Features/Core/Portable/SplitOrMergeIfStatements/IIfLikeStatementGenerator.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複合条件のif文分割と連続if文の結合機能 | E-01, E-02, E-04 (58行目) | ○ |
| C-02 | IIfLikeStatementGeneratorインターフェース | E-03 (16-66行目) | ○ |
| C-03 | IsIfOrElseIfでif/else-ifを判定 | E-03 (18行目) | ○ |
| C-04 | IsConditionで条件式を判定 | E-03 (20行目) | ○ |
| C-05 | GetLogicalExpressionKindで演算子種別を取得 | E-01 (21行目) | ○ |
| C-06 | IsPartOfBinaryExpressionChainで二項式チェーン検出 | E-01 (78-92行目) | ○ |
| C-07 | SplitBinaryExpressionChainで左右分解 | E-01 (94-110行目) | ○ |
| C-08 | 左結合の二項式チェーンを処理 | E-01 (97-102行目コメント) | ○ |
| C-09 | CanBeMergedUp/CanBeMergedDownで結合可能性判定 | E-02 (27-31行目) | ○ |
| C-10 | MergeDirection列挙型（Up, Down） | E-02 (124行目) | ○ |
| C-11 | WalkDownScopeBlocksでスコープブロック処理 | E-02 (87-98行目) | ○ |
| C-12 | WalkUpScopeBlocksでスコープブロック処理 | E-02 (100-122行目) | ○ |
| C-13 | GetElseIfAndElseClausesでelse-ifチェーン取得 | E-03 (36行目) | ○ |
| C-14 | InsertElseIfClause/RemoveElseIfClauseでelse-if操作 | E-03 (60-65行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#固有の実装（CSharp*Provider）が存在するか確認
- [ ] VB固有の実装（VisualBasic*Provider）が存在するか確認
- [ ] OR分割時のelse-ifチェーン生成が正しいか確認
