---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-条件反転

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/InvertIf/AbstractInvertIfCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | if文の条件を反転してtrue/false分岐を入れ替え | E-01 (クラス設計), E-02 (59行目) | ○ |
| C-02 | InvertIfStyle列挙型で8種類のスタイル | E-01 (38-48行目) | ○ |
| C-03 | IfWithElse_SwapIfBodyWithElseBody | E-01 (40行目, 544-554行目) | ○ |
| C-04 | IfWithoutElse_SwapIfBodyWithSubsequentStatements | E-01 (41行目, 579-619行目) | ○ |
| C-05 | IfWithoutElse_MoveSubsequentStatementsToIfBody | E-01 (42行目, 672-703行目) | ○ |
| C-06 | IfWithoutElse_WithElseClause | E-01 (43行目, 705-728行目) | ○ |
| C-07 | IfWithoutElse_WithNearmostJumpStatement | E-01 (46行目, 622-644行目) | ○ |
| C-08 | ComputeRefactoringsAsyncがエントリーポイント | E-01 (93-99行目) | ○ |
| C-09 | ディレクティブ反転をサポート | E-01 (101-189行目) | ○ |
| C-10 | 3要素（#if/#else/#endif）のみディレクティブ反転可能 | E-01 (124-132行目) | ○ |
| C-11 | SyntaxGenerator.Negateで条件反転 | E-01 (163-167行目, 416-420行目) | ○ |
| C-12 | SemanticModel.AnalyzeControlFlowで制御フロー解析 | E-01 (454-456行目) | ○ |
| C-13 | GetNearestParentJumpStatementKindで最近傍ジャンプ取得 | E-01 (470-480行目) | ○ |
| C-14 | CanInvertで反転可能性をチェック | E-01 (65行目, 201行目) | ○ |
| C-15 | IsElselessでelse有無を判定 | E-01 (66行目, 220行目) | ○ |
| C-16 | HasErrorDiagnosticsでエラー診断をチェック | E-01 (114-115行目, 191-192行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#固有の実装（CSharpInvertIfCodeRefactoringProvider）が存在するか確認
- [ ] VB固有の実装（VisualBasicInvertIfCodeRefactoringProvider）が存在するか確認
- [ ] 複雑な制御フロー（ネストしたif文内）での反転が正しいか確認
