---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-拡張機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードから確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/CodeFixes/Service/CodeFixService.cs`
- E-02: `src/Features/Core/Portable/CodeRefactorings/CodeRefactoringService.cs`
- E-03: `src/Features/Core/Portable/CodeFixes/CodeFixCollection.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CodeFixServiceはICodeFixServiceを実装 | E-01 (39-40行目 Export, implements ICodeFixService) | ○ |
| C-02 | MEF ImportでCodeFixProvider読み込み | E-01 (62行目 ImportMany) | ○ |
| C-03 | ConditionalWeakTableでプロジェクトフィクサーキャッシュ | E-01 (45行目 _projectFixersMap) | ○ |
| C-04 | 抑制済み診断を除外 | E-01 (111行目 IsSuppressed フィルタ) | ○ |
| C-05 | 優先度フィルタリング対応 | E-01 (83-84行目 CodeActionRequestPriority) | ○ |
| C-06 | CodeRefactoringServiceはICodeRefactoringServiceを実装 | E-02 (27-31行目) | ○ |
| C-07 | 言語/ドキュメント種別によるプロバイダーマップ | E-02 (33-39行目 LanguageDocumentToProvidersMap) | ○ |
| C-08 | DistributeLanguagesAndDocumentsでプロバイダー分類 | E-02 (45-72行目) | ○ |
| C-09 | ExtensionOrdererで順序付け | E-02 (39行目 ExtensionOrderer.Order) | ○ |
| C-10 | ドキュメント種別 (TextDocumentKind) 対応 | E-02 (55行目 Enum.Parse TextDocumentKind) | ○ |
| C-11 | ファイル拡張子によるプロバイダーフィルタ | E-02 (93-99行目) | ○ |
| C-12 | FixAllProviderInfoの管理 | E-01 (55行目), E-02 (43行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能なサービス構造
- 0: 低リスク - MEF統合の記述
- 0: 低リスク - フィルタリングロジックの記述

## 6) レビュアーチェックリスト（最小）
- [ ] CodeFixServiceの主要メソッドが網羅されているか確認
- [ ] CodeRefactoringServiceのプロバイダー検索ロジックが正確か確認
- [ ] MEFによるプロバイダー読み込みの説明が正確か確認
- [ ] FixAllProviderの説明が正確か確認
