---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-論理反転

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/InvertLogical/AbstractInvertLogicalCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 論理AND/ORの相互変換とド・モルガン適用 | E-01 (17-18行目コメント), E-02 (60行目) | ○ |
| C-02 | GetOperatorText抽象メソッドで演算子テキスト取得 | E-01 (33行目) | ○ |
| C-03 | s_annotationで変換結果を識別 | E-01 (31行目) | ○ |
| C-04 | IsLogicalAndExpression/IsLogicalOrExpressionで判定 | E-01 (43-46行目) | ○ |
| C-05 | 空選択時は最上位の二項式を対象 | E-01 (50-58行目) | ○ |
| C-06 | 非空選択時は完全選択のみ対象 | E-01 (60-70行目) | ○ |
| C-07 | IsNodeUnderselectedでアンダーセレクトをチェック | E-01 (66行目) | ○ |
| C-08 | InvertLogicalAsyncで2段階の否定を適用 | E-01 (82-97行目) | ○ |
| C-09 | InvertInnerExpressionAsyncで内部否定 | E-01 (99-111行目) | ○ |
| C-10 | InvertOuterExpressionAsyncで外部否定 | E-01 (113-137行目) | ○ |
| C-11 | negateBinary:falseで二重否定を防止 | E-01 (133-136行目コメント) | ○ |
| C-12 | GetAnnotatedNodesでアノテーション付きノードを取得 | E-01 (120行目) | ○ |
| C-13 | 親が括弧または論理NOTの場合は辿り上がる | E-01 (124-128行目) | ○ |
| C-14 | GetTitleで演算子置換タイトルを生成 | E-01 (139-142行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#固有の実装（CSharpInvertLogicalCodeRefactoringProvider）が存在するか確認
- [ ] VB固有の実装（VisualBasicInvertLogicalCodeRefactoringProvider）が存在するか確認
- [ ] 複雑なネスト式（`(a && b) || (c && d)`）での変換が正しいか確認
