---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：61-usingディレクティブ追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **BR-61-04 高優先度処理**：CodeActionRequestPriority.Highの根拠確認
  2. **NuGetパッケージ検索オプション**：オプション設定の詳細仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/AddImport/AbstractAddImportCodeFixProvider.cs`
- E-02: `src/Features/Core/Portable/AddImport/AbstractAddImportFeatureService.cs`
- E-03: `src/Features/Core/Portable/AddImport/IAddImportFeatureService.cs`
- E-04: `src/Features/Core/Portable/AddImport/AddImportFixData.cs`
- E-05: `src/Features/Core/Portable/AddImport/SymbolReferenceFinder.cs`
- E-06: `src/Features/Core/Portable/AddImport/References/Reference.cs`
- E-07: `src/Features/Core/Portable/AddImport/SearchScopes/SearchScope.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 未解決の型名に対してusingディレクティブを追加する | E-01, E-02 | ○ |
| C-02 | CS0246等の診断IDに対応 | E-01 (ImmutableFixableDiagnosticIds参照) | ○ |
| C-03 | リモートホストが利用可能ならOOPで処理 | E-02 (65-87行目) | ○ |
| C-04 | 現在プロジェクト→未参照プロジェクト→メタデータ→NuGetの順で検索 | E-02 (171-206行目) | ○ |
| C-05 | 最大5件の候補を返す | E-01 (16行目 MaxResults = 5) | ○ |
| C-06 | NuGetパッケージディレクトリ内のDLLは直接参照として提案しない | E-02 (376-418行目 IsInPackagesDirectory) | ○ |
| C-07 | CodeActionRequestPriority.Highで処理される | E-01 (40-41行目 ComputeRequestPriority) | ○ |
| C-08 | FixAllProviderは未サポート | E-01 (43-48行目 GetFixAllProvider returns null) | ○ |
| C-09 | AddImportFixDataはDataContractでシリアライズ可能 | E-04 (15-29行目 DataContract属性) | ○ |
| C-10 | ISymbolSearchServiceとIPackageInstallerServiceと連携 | E-01 (61-64行目) | ○ |
| C-11 | 完全一致検索→あいまい検索の順で実行 | E-02 (154-165行目) | ○ |
| C-12 | 検索結果が十分な数に達した時点で追加検索をキャンセル | E-02 (350-374行目 linkedTokenSource.Cancel) | ○ |
| C-13 | プロジェクト参照追加も提案可能 | E-04 (ProjectReferenceToAdd) | ○ |
| C-14 | メタデータ参照追加も提案可能 | E-04 (PortableExecutableReferenceFilePathToAdd) | ○ |
| C-15 | パッケージ参照追加も提案可能 | E-04 (PackageName, PackageSource) | ○ |
| C-16 | TextChangesでドキュメント変更を表現 | E-04 (41行目) | ○ |
| C-17 | NuGetパッケージ検索はオプションで有効/無効を切り替え可能 | **根拠なし** | △ |
| C-18 | 大規模ソリューションでも応答性を確保 | **根拠なし（設計意図として推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17：AddImportOptionsの詳細な定義ファイルを確認すれば根拠が得られる可能性あり
  - 候補：`AddImportOptions.cs` / `SymbolSearchOptions` / IDE設定ファイル
- C-18：パフォーマンス要件に関する明示的なドキュメントや設計書は確認されていない
  - 候補：設計ドキュメント / パフォーマンステスト / Issue tracker

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードから直接確認可能
- 1: 中リスク - オプション設定の詳細仕様が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のComputeRequestPriorityがHighであることを確認
- [ ] E-02の検索順序ロジック（171-206行目）を確認
- [ ] AddImportOptionsの定義を確認し、NuGetオプションの存在を検証
- [ ] FixAllProvider未サポートの理由（GitHub Issue #34457）を確認
