---
generated_at: 2026-02-10 14:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-型の完全修飾

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyService.cs`
- E-02: `src/Features/Core/Portable/FullyQualify/IFullyQualifyService.cs`
- E-03: `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyCodeFixProvider.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 最大3件の候補を返す | E-01 (30行目 MaxResults = 3) | ○ |
| C-02 | NamespaceWithNoErrorsWeight = 0 | E-01 (32行目) | ○ |
| C-03 | TypeWeight = 1 | E-01 (33行目) | ○ |
| C-04 | NamespaceWithErrorsWeight = 2 | E-01 (34行目) | ○ |
| C-05 | OOP利用可能ならリモートで処理 | E-01 (42-54行目) | ○ |
| C-06 | 型の検索にSymbolFilter.Type使用 | E-01 (78行目) | ○ |
| C-07 | 名前空間の検索にSymbolFilter.Namespace使用 | E-01 (80行目) | ○ |
| C-08 | 属性コンテキストでは属性型も検索 | E-01 (79行目 inAttributeContext) | ○ |
| C-09 | DeclarationFinderで検索 | E-01 (115-116行目) | ○ |
| C-10 | アクセシビリティチェック | E-01 (243行目 IsAccessibleWithin) | ○ |
| C-11 | アリティチェック | E-01 (231-236行目) | ○ |
| C-12 | コードクリーンアップ適用 | E-01 (221-222行目 CleanupDocumentAsync) | ○ |
| C-13 | 抽象メソッドCanFullyQualify | E-01 (36行目) | ○ |
| C-14 | 抽象メソッドReplaceNodeAsync | E-01 (37行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01の重み付けロジック（GetTypeSearchResults、GetNamespaceSearchResults）を確認
- [ ] E-01のFilterAndSortロジックを確認
- [ ] 言語固有実装（C#、VB）の派生クラスを確認
