---
generated_at: 2026-02-10 14:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：66-診断エンジン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **インクリメンタル分析**：IncrementalMemberEditAnalyzerの詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/Diagnostics/IDiagnosticAnalyzerService.cs`
- E-02: `src/Features/Core/Portable/Diagnostics/Service/DiagnosticAnalyzerService.cs`
- E-03: `src/Features/Core/Portable/Diagnostics/Service/DocumentAnalysisExecutor.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnalyzerExceptionDiagnosticId = "AD0001" | E-02 (51行目) | ○ |
| C-02 | _hostAnalyzerStateMapでホストアナライザー管理 | E-02 (67行目) | ○ |
| C-03 | _projectAnalyzerStateMapでプロジェクトアナライザー管理 | E-02 (73行目) | ○ |
| C-04 | オプション変更時に診断リフレッシュ | E-02 (85-91行目) | ○ |
| C-05 | BackgroundAnalysisScopeOption対応 | E-02 (107行目) | ○ |
| C-06 | CompilerDiagnosticsScopeOption対応 | E-02 (108行目) | ○ |
| C-07 | dotnet_crash_on_analyzer_exception対応 | E-02 (53行目, 101-102行目) | ○ |
| C-08 | FadeOutUnusedImports変更時に再計算 | E-02 (112行目) | ○ |
| C-09 | RequestDiagnosticRefreshでリフレッシュ要求 | E-02 (116-117行目) | ○ |
| C-10 | IDiagnosticsRefresherで通知 | E-02 (58行目, 117行目) | ○ |
| C-11 | ForceRunCodeAnalysisDiagnosticsAsync対応 | E-01 (31-32行目) | ○ |
| C-12 | GetDiagnosticsForSpanAsync対応 | E-01 (89-94行目) | ○ |
| C-13 | IsAnyDiagnosticIdDeprioritizedAsync対応 | E-01 (41-42行目) | ○ |
| C-14 | DiagnosticIdFilterでフィルタリング | E-01 (91行目) | ○ |
| C-15 | DocumentActiveContextChangedHandler登録 | E-02 (95行目) | ○ |
| C-16 | IncrementalMemberEditAnalyzerで増分分析 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16：IncrementalMemberEditAnalyzer（61行目で参照）の詳細実装は別ファイル
  - 候補：`DiagnosticAnalyzerService.IncrementalMemberEditAnalyzer.cs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な主張はソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-02のオプション変更ハンドラを確認
- [ ] E-01の各APIの詳細実装を確認
- [ ] IncrementalMemberEditAnalyzerの詳細を確認
- [ ] リモート/インプロセス振り分けロジックを確認
