---
generated_at: 2026-02-10 15:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-スペルチェック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/SpellCheck/AbstractSpellCheckCodeFixProvider.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MinTokenLength = 3 | E-01 (23行目) | ○ |
| C-02 | FixAllProvider未サポート | E-01 (25-30行目 returns null) | ○ |
| C-03 | ノードとトークンの両方をチェック | E-01 (48-60行目) | ○ |
| C-04 | SimpleNameSyntaxを処理 | E-01 (66行目) | ○ |
| C-05 | 最大3件の候補 | E-01 (176行目 .Take(3)) | ○ |
| C-06 | CodeActionPriority.Low | E-01 (188-189行目, 217行目) | ○ |
| C-07 | スニペット除外 | E-01 (122行目 SnippetsBehavior = NeverInclude) | ○ |
| C-08 | 未インポート型除外 | E-01 (123行目 ShowItemsFromUnimportedNamespaces = false) | ○ |
| C-09 | ジェネリック考慮 | E-01 (152行目, 156-159行目 onlyConsiderGenerics) | ○ |
| C-10 | WordSimilarityChecker使用 | E-01 (138行目) | ○ |
| C-11 | substringsAreSimilar = true | E-01 (138行目) | ○ |
| C-12 | matchCostでソート | E-01 (169行目, 173行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のCheckNodeAsync/CheckTokenAsyncロジックを確認
- [ ] WordSimilarityCheckerの類似度計算アルゴリズムを確認
- [ ] 言語固有実装（C#、VB）の派生クラスを確認
