---
generated_at: 2026-02-10 15:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-未使用参照検出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/UnusedReferences/UnusedReferencesRemover.cs`
- E-02: `src/Features/Core/Portable/UnusedReferences/ReferenceInfo.cs`
- E-03: `src/Features/Core/Portable/UnusedReferences/ReferenceType.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 処理順序: Project→Package→Assembly | E-01 (23行目 s_processingOrder) | ○ |
| C-02 | GetUnusedReferencesAsyncエントリーポイント | E-01 (25-62行目) | ○ |
| C-03 | compilation.GetUsedAssemblyReferencesで使用アセンブリ取得 | E-01 (45行目) | ○ |
| C-04 | PortableExecutableReferenceからパス取得 | E-01 (48-51行目) | ○ |
| C-05 | CompilationReferenceからファイル名取得 | E-01 (55-58行目) | ○ |
| C-06 | 2パス処理（直接→推移的） | E-01 (86-107行目, 110-123行目) | ○ |
| C-07 | プロジェクト参照はファイル名で比較 | E-01 (148-163行目) | ○ |
| C-08 | その他参照はパスで比較 | E-01 (165-175行目) | ○ |
| C-09 | コンパイルアセンブリなしは使用済み扱い | E-01 (204-209行目) | ○ |
| C-10 | HasAnyCompilationAssemblyで再帰チェック | E-01 (226-234行目) | ○ |
| C-11 | ContainsAnyCompilationAssemblyで再帰チェック | E-01 (236-244行目) | ○ |
| C-12 | RemoveAllCompilationAssembliesで使用済みパス削除 | E-01 (246-254行目) | ○ |
| C-13 | UpdateReferencesAsyncで参照更新 | E-01 (263-272行目) | ○ |
| C-14 | IReferenceCleanupService.TryUpdateReferenceAsync使用 | E-01 (300-303行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のs_processingOrder処理順序を確認
- [ ] E-01のRemoveDirectlyUsedReferencesロジックを確認
- [ ] E-01のRemoveTransitivelyUsedReferencesロジックを確認
- [ ] IReferenceCleanupServiceの実装を確認
