---
generated_at: 2026-02-10 15:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-タスクリスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/TaskList/AbstractTaskListService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PreprocessorHasComment抽象メソッド | E-01 (17行目) | ○ |
| C-02 | IsSingleLineComment抽象メソッド | E-01 (18行目) | ○ |
| C-03 | IsMultilineComment抽象メソッド | E-01 (19行目) | ○ |
| C-04 | IsIdentifierCharacter抽象メソッド | E-01 (20行目) | ○ |
| C-05 | OOP利用可能ならリモートで処理 | E-01 (31-43行目) | ○ |
| C-06 | 記述子が空なら空の結果を返す | E-01 (53-54行目) | ○ |
| C-07 | DescendantTriviaでトリビア取得 | E-01 (64行目) | ○ |
| C-08 | ContainsCommentsでコメント判定 | E-01 (68-69行目, 77-78行目) | ○ |
| C-09 | 大文字小文字無視で比較 | E-01 (94-96行目 OrdinalIgnoreCase) | ○ |
| C-10 | 識別子文字チェック | E-01 (101-106行目) | ○ |
| C-11 | #lineリマッピング考慮 | E-01 (112行目 GetMappedLineSpan) | ○ |
| C-12 | 複数行コメントは各行を個別処理 | E-01 (143-159行目) | ○ |
| C-13 | SyntacticDocumentでテキストとツリーを保持 | E-01 (59行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のAppendTaskListItemsOnSingleLineロジックを確認
- [ ] E-01のProcessMultilineCommentロジックを確認
- [ ] C#/VB固有実装の抽象メソッド実装を確認
- [ ] TaskListItemDescriptorの設定方法を確認
