---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：72-括弧マッチング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（数ミリ秒以内）**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/BraceMatching/IBraceMatchingService.cs`
- E-02: `src/Features/Core/Portable/BraceMatching/BraceMatchingService.cs`
- E-03: `src/Features/Core/Portable/BraceMatching/AbstractBraceMatcher.cs`
- E-04: `src/Features/Core/Portable/BraceMatching/IBraceMatcher.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 対応する括弧のペアをハイライト表示する | E-01, E-02 | ○ |
| C-02 | BraceMatchingResultでLeftSpanとRightSpanを返却 | E-01 (17-20行目) | ○ |
| C-03 | GetMatchingBracesAsyncで非同期にマッチング実行 | E-01 (14行目), E-02 (24-44行目) | ○ |
| C-04 | MEFで登録されたIBraceMatcherを使用 | E-02 (19-20行目 ImportMany) | ○ |
| C-05 | 言語に応じたマッチャーをフィルタリング | E-02 (32行目) | ○ |
| C-06 | 親ノード内で開き括弧と閉じ括弧を検索 | E-03 (27-56行目 TryFindMatchingToken) | ○ |
| C-07 | 正確に2つのトークンがある場合のみマッチ | E-03 (38-40行目) | ○ |
| C-08 | 長さ0のスパンを持つトークンは除外 | E-03 (35行目 tok.Span.Length > 0) | ○ |
| C-09 | 開き括弧と閉じ括弧のBraceCharacterAndKindを保持 | E-03 (16-17行目) | ○ |
| C-10 | FindBracesAsyncでメインのマッチング処理 | E-03 (58-89行目) | ○ |
| C-11 | DataContract属性でシリアライズ可能 | E-01 (17行目) | ○ |
| C-12 | 埋め込み言語のマッチングに対応 | E-04 (IEmbeddedLanguageBraceMatcher存在確認) | ○ |
| C-13 | ディレクティブトリビアのマッチングをサポート | E-03 (AbstractDirectiveTriviaBraceMatcher存在確認) | ○ |
| C-14 | C#とVisual Basicの両言語で利用可能 | E-02, E-05 | ○ |
| C-15 | パフォーマンス要件：数ミリ秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: パフォーマンス要件の「数ミリ秒以内」という数値は一般的なエディタUXの推奨値であるが、Roslyn固有の要件定義は確認できなかった
  - 候補：Visual Studio パフォーマンスガイドライン / エディタチームの内部ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の主要なロジックはソースコードから明確に確認できる
- 0: 低リスク - パフォーマンス要件は一般的なエディタ機能として妥当

## 6) レビュアーチェックリスト（最小）
- [ ] BraceMatchingResult構造体の定義が正確か確認
- [ ] TryFindMatchingTokenのロジックが正しく記載されているか確認
- [ ] MEFによるマッチャー登録の仕組みが正確か確認
- [ ] 埋め込み言語サポートの範囲を確認
