---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-フォーマット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/Formatting/INewDocumentFormattingService.cs`
- E-02: `src/Features/Core/Portable/Formatting/AbstractNewDocumentFormattingService.cs`
- E-03: `src/Features/Core/Portable/Formatting/INewDocumentFormattingProvider.cs`
- E-04: `src/Features/Core/Portable/Formatting/ExportNewDocumentFormattingProviderAttribute.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規ドキュメントのフォーマットサービスを提供 | E-01 | ○ |
| C-02 | INewDocumentFormattingServiceがILanguageServiceを継承 | E-01 (12行目) | ○ |
| C-03 | FormatNewDocumentAsyncで新規ドキュメントをフォーマット | E-01 (19行目), E-02 (35-65行目) | ○ |
| C-04 | 複数のプロバイダーで段階的にフォーマット | E-02 (37-61行目 foreach) | ○ |
| C-05 | 言語でプロバイダーをフィルタリング | E-02 (31行目) | ○ |
| C-06 | ドキュメント変更時はCleanupSyntaxAsyncを実行 | E-02 (54-57行目) | ○ |
| C-07 | エラー時はログ記録して続行 | E-02 (59行目 FatalError.ReportAndCatchUnlessCanceled) | ○ |
| C-08 | プロバイダーは独立して動作 | E-02 (42-43行目 コメント) | ○ |
| C-09 | ExportNewDocumentFormattingProviderAttributeでMEFエクスポート | E-04 | ○ |
| C-10 | Languageプロパティで言語指定 | E-02 (22行目) | ○ |
| C-11 | hintDocumentパラメータはオプション | E-01 (18行目 Document?) | ○ |
| C-12 | CodeCleanupOptionsでオプション設定 | E-01 (19行目), E-02 (35行目) | ○ |
| C-13 | C#とVisual Basicで利用可能 | E-01 (ILanguageService), E-05 | ○ |
| C-14 | 関連画面はC#書式設定オプションページ | E-06 (画面No.35) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の全てのロジックがソースコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] FormatNewDocumentAsyncの処理フローが正確か確認
- [ ] プロバイダーのフィルタリングロジックを確認
- [ ] CleanupSyntaxAsyncの呼び出し条件を確認
- [ ] エラーハンドリングの動作を確認
