---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：77-行セパレータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **言語固有実装の詳細**：Core/Portableにはインターフェースのみ

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/LineSeparators/ILineSeparatorService.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メンバー間に視覚的な区切り線を表示 | E-01, E-02 | ○ |
| C-02 | ILineSeparatorServiceがILanguageServiceを継承 | E-01 (13行目) | ○ |
| C-03 | GetLineSeparatorsAsyncでセパレータ位置を取得 | E-01 (15行目) | ○ |
| C-04 | TextSpanのImmutableArrayを返却 | E-01 (15行目) | ○ |
| C-05 | Document、TextSpan、CancellationTokenを引数に取る | E-01 (15行目) | ○ |
| C-06 | 非同期メソッド（Task<ImmutableArray<TextSpan>>） | E-01 (15行目) | ○ |
| C-07 | C#とVisual Basicで利用可能 | E-01 (ILanguageService), E-02 | ○ |
| C-08 | 表示範囲限定でパフォーマンス確保 | E-01 (TextSpan引数) | ○ |
| C-09 | メソッド、プロパティ、フィールド間にセパレータ表示 | E-02（機能説明） | ○ |
| C-10 | 言語固有実装でメンバー種別判定 | **言語固有実装要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- C-10: Core/Portableにはインターフェースのみ存在し、言語固有の実装は別のパスにある
  - 候補：src/Features/CSharp/Portable/LineSeparators/ / src/Features/VisualBasic/Portable/LineSeparators/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義は明確
- 1: 中リスク - 言語固有実装の詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ILineSeparatorServiceインターフェースの定義が正確か確認
- [ ] C#固有のLineSeparatorService実装を確認
- [ ] VB固有のLineSeparatorService実装を確認
- [ ] エディタ装飾レイヤーとの連携を確認（EditorFeatures層）
