---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-コード構造

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/Structure/BlockStructureService.cs`
- E-02: `src/Features/Core/Portable/Structure/BlockStructure.cs`
- E-03: `src/Features/Core/Portable/Structure/BlockSpan.cs`
- E-04: `src/Features/Core/Portable/Structure/BlockTypes.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コードのアウトライン表示と折りたたみ機能を提供 | E-01, E-05 | ○ |
| C-02 | BlockStructureServiceがILanguageServiceを継承 | E-01 (14行目) | ○ |
| C-03 | GetBlockStructureAsyncで構造を非同期取得 | E-01 (27行目) | ○ |
| C-04 | BlockStructureはBlockSpanのコレクションを保持 | E-02 (9-12行目) | ○ |
| C-05 | BlockSpanにTextSpan、HintSpan、Typeプロパティがある | E-03 (10-18行目) | ○ |
| C-06 | IsCollapsibleで折りたたみ可能かを示す | E-03 (25行目) | ○ |
| C-07 | AutoCollapseで「定義に折りたたむ」対象かを示す | E-03 (64行目) | ○ |
| C-08 | IsDefaultCollapsedでデフォルト折りたたみを示す | E-03 (69行目) | ○ |
| C-09 | BannerTextで折りたたみ時の表示テキストを設定 | E-03 (59行目) | ○ |
| C-10 | SubHeadingsで関連ブロック情報を保持 | E-03 (54行目) | ○ |
| C-11 | BlockTypes.Typeでクラス等の種別を定義 | E-04 (19行目) | ○ |
| C-12 | BlockTypes.Memberでメソッド等の種別を定義 | E-04 (20行目) | ○ |
| C-13 | BlockTypes.Statementで文の種別を定義 | E-04 (23行目) | ○ |
| C-14 | BlockTypes.Expressionで式の種別を定義 | E-04 (27行目) | ○ |
| C-15 | BlockTypes.Commentでコメントの種別を定義 | E-04 (13行目) | ○ |
| C-16 | BlockTypes.PreprocessorRegionでリージョンの種別を定義 | E-04 (14行目) | ○ |
| C-17 | IsOverlappingBlockSpanで重複ブロックを検出 | E-03 (118-142行目) | ○ |
| C-18 | GetServiceでドキュメントからサービスを取得 | E-01 (19-20行目) | ○ |
| C-19 | C#とVisual Basicで利用可能 | E-01 (Language), E-05 | ○ |
| C-20 | 関連画面はドキュメントアウトラインビュー | E-06 (画面No.14) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の全てのロジックがソースコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] BlockSpan構造体の各プロパティが正確に記載されているか確認
- [ ] BlockTypesの全種別が網羅されているか確認
- [ ] プロバイダーベースのアーキテクチャが正しく記載されているか確認
- [ ] 重複ブロック検出ロジックを確認
- [ ] ドキュメントアウトラインビューとの連携を確認
