---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：79-文字列インデント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **言語固有実装の詳細**：Core/Portableにはインターフェースのみ

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/StringIndentation/IStringIndentationService.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数行文字列のインデント位置を視覚的に表示 | E-01, E-02 | ○ |
| C-02 | IStringIndentationServiceがILanguageServiceを継承 | E-01 (13行目) | ○ |
| C-03 | GetStringIndentationRegionsAsyncでインデント領域を取得 | E-01 (15行目) | ○ |
| C-04 | StringIndentationRegionにIndentSpanプロパティがある | E-01 (55行目) | ○ |
| C-05 | StringIndentationRegionにOrderedHoleSpansプロパティがある | E-01 (109行目) | ○ |
| C-06 | IndentSpanは文字列開始行から終了"""の直前まで | E-01 (22-55行目 ドキュメント) | ○ |
| C-07 | 穴領域は補間式{...}のスパン | E-01 (57-107行目 ドキュメント) | ○ |
| C-08 | 穴領域ではガイドラインを描画しない | E-01 (90-106行目 描画例) | ○ |
| C-09 | 複数の補間式がある場合は順序付きで返却 | E-01 (109行目 Sort()) | ○ |
| C-10 | Document、TextSpan、CancellationTokenを引数に取る | E-01 (15行目) | ○ |
| C-11 | 非同期メソッド（Task<ImmutableArray<StringIndentationRegion>>） | E-01 (15行目) | ○ |
| C-12 | C# 11以降の生文字列リテラルに対応 | E-02（機能説明） | ○ |
| C-13 | コンストラクタでholeSpansはdefaultを許容 | E-01 (18行目) | ○ |
| C-14 | 言語固有実装でリテラル検出 | **言語固有実装要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: Core/Portableにはインターフェースのみ存在し、言語固有の実装は別のパスにある
  - 候補：src/Features/CSharp/Portable/StringIndentation/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とドキュメントが充実
- 1: 中リスク - 言語固有実装の詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] StringIndentationRegion構造体の定義が正確か確認
- [ ] IndentSpanの計算ロジックがドキュメントと一致しているか確認
- [ ] OrderedHoleSpansの動作を確認
- [ ] C#固有のStringIndentationService実装を確認
- [ ] エディタ装飾レイヤーとの連携を確認（EditorFeatures層）
