---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-インラインヒント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/InlineHints/IInlineHintsService.cs`
- E-02: `src/Features/Core/Portable/InlineHints/AbstractInlineHintsService.cs`
- E-03: `src/Features/Core/Portable/InlineHints/InlineHint.cs`
- E-04: `src/Features/Core/Portable/InlineHints/InlineHintsOptions.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パラメータ名や型情報をインラインで表示 | E-01, E-05 | ○ |
| C-02 | IInlineHintsServiceがILanguageServiceを継承 | E-01 (13行目) | ○ |
| C-03 | GetInlineHintsAsyncでヒントを非同期取得 | E-01 (15-16行目), E-02 (17-37行目) | ○ |
| C-04 | InlineHint構造体にSpanプロパティがある | E-03 (16行目) | ○ |
| C-05 | InlineHint構造体にDisplayPartsプロパティがある | E-03 (17行目) | ○ |
| C-06 | InlineHint構造体にReplacementTextChangeプロパティがある | E-03 (18行目) | ○ |
| C-07 | InlineHint構造体にRankingプロパティがある | E-03 (19行目) | ○ |
| C-08 | GetDescriptionAsyncでホバー時の説明を取得 | E-03 (60-61行目) | ○ |
| C-09 | InlineHintsOptionsにParameterOptionsがある | E-04 (13行目) | ○ |
| C-10 | InlineHintsOptionsにTypeOptionsがある | E-04 (14行目) | ○ |
| C-11 | InlineHintsOptionsにDisplayOptionsがある | E-04 (15行目) | ○ |
| C-12 | パラメータ名ヒントサービスを呼び出し | E-02 (20行目, 26-28行目) | ○ |
| C-13 | 型ヒントサービスを呼び出し | E-02 (21行目, 30-33行目) | ○ |
| C-14 | ArrayBuilderで結果を収集 | E-02 (24行目) | ○ |
| C-15 | 大規模配列をプールで再利用 | E-02 (24行目 discardLargeInstances: false) | ○ |
| C-16 | displayAllOverrideパラメータがある | E-01 (16行目), E-02 (18行目) | ○ |
| C-17 | Document, TextSpan, options, cancellationTokenを引数に取る | E-01 (15-16行目) | ○ |
| C-18 | ImmutableArray<InlineHint>を返却 | E-01 (15行目), E-02 (36行目) | ○ |
| C-19 | サービスがnullの場合はスキップ | E-02 (26行目, 30行目) | ○ |
| C-20 | ConfigureAwait(false)を使用 | E-02 (28行目, 33行目) | ○ |
| C-21 | 複数のコンストラクタオーバーロード | E-03 (22-54行目) | ○ |
| C-22 | C#とVisual Basicで利用可能 | E-01 (ILanguageService), E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の全てのロジックがソースコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] InlineHint構造体の各プロパティが正確か確認
- [ ] InlineHintsOptionsの設定項目が網羅されているか確認
- [ ] パラメータ名ヒントサービスと型ヒントサービスの連携を確認
- [ ] ArrayBuilderのプール再利用の動作を確認
- [ ] 言語固有実装（C#、VB）を確認
