---
generated_at: 2026-02-10 13:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-コードラッピング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件100ms**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Wrapping/AbstractWrappingCodeRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/Wrapping/ISyntaxWrapper.cs`
- E-03: `src/Features/Core/Portable/Wrapping/AbstractCodeActionComputer.cs`
- E-04: `src/Features/Core/Portable/Wrapping/WrapItemsAction.cs`
- E-05: `src/Features/Core/Portable/Wrapping/SyntaxWrappingOptions.cs`
- E-06: `src/Features/Core/Portable/Wrapping/SeparatedSyntaxList/AbstractSeparatedSyntaxListWrapper.cs`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コードラッピングは引数リスト、パラメータリスト、二項式、メソッドチェーンを対象とする | E-01, E-06 | ○ |
| C-02 | ComputeRefactoringsAsyncでカーソル位置から親ノードを走査する | E-01 (35-77行) | ○ |
| C-03 | ISyntaxWrapperインターフェースがTryCreateComputerAsyncを定義 | E-02 | ○ |
| C-04 | 2要素以上のリストのみが対象となる | E-06 (70-76行) | ○ |
| C-05 | 構文エラー時は処理をスキップする場合がある | E-01 (50, 74-75行) | ○ |
| C-06 | MRU順序でラッピングオプションを優先表示する | E-04 (31, 50-51行) | ○ |
| C-07 | TryCreateCodeActionAsyncで重複アクションを除外する | E-03 (143-154行) | ○ |
| C-08 | ホワイトスペース以外のトリビアは編集不可 | E-03 (182-185, 207-218行) | ○ |
| C-09 | SyntaxWrappingOptionsはFormattingOptionsを内包する | E-05 (12行) | ○ |
| C-10 | CodeActionPriority.Lowで表示される | E-04 (21行), E-03 (304行) | ○ |
| C-11 | RecordCodeActionOperationでMRU履歴を管理 | E-04 (84-98行) | ○ |
| C-12 | カンマ区切りリストのラッピングを提供 | E-06 | ○ |
| C-13 | 二項式のラッピングを提供 | E-01 (54行でwrappers使用) | ○ |
| C-14 | メソッドチェーンのラッピングを提供 | E-01 (54行でwrappers使用) | ○ |
| C-15 | EditorConfig設定と連携する | E-05 (23-26行) | ○ |
| C-16 | GetTopLevelCodeActionsAsyncでラッピンググループをアクションに変換 | E-03 (271-315行) | ○ |
| C-17 | FormatDocumentAsyncでドキュメントを整形 | E-03 (163-170行) | ○ |
| C-18 | パフォーマンス要件100ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（100ms）は明示的なドキュメントやコード上の定義が確認できない
  - 候補：パフォーマンステスト / ベンチマーク結果 / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから根拠を得られている
- パフォーマンス要件のみ根拠不明だが、機能動作には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] C-18のパフォーマンス要件について、適切な数値かどうか確認
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
