---
generated_at: 2026-02-10 13:32:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-Edit and Continue

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/EditAndContinue/IEditAndContinueService.cs`
- E-02: `src/Features/Core/Portable/EditAndContinue/EditAndContinueService.cs`
- E-03: `src/Features/Core/Portable/EditAndContinue/DebuggingSession.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Edit and Continueはデバッグ中にコードを修正して適用する機能 | E-04 (83行), E-02 | ○ |
| C-02 | StartDebuggingSessionでセッション開始 | E-01 (27行), E-02 (151-178行) | ○ |
| C-03 | EndDebuggingSessionでセッション終了 | E-01 (29行), E-02 (180-193行) | ○ |
| C-04 | GetDocumentDiagnosticsAsyncで診断取得 | E-01 (21行), E-02 (202-208行) | ○ |
| C-05 | EmitSolutionUpdateAsyncでデルタ発行 | E-01 (22行), E-02 (210-224行) | ○ |
| C-06 | CommitSolutionUpdateで更新確定 | E-01 (24行), E-02 (226-232行) | ○ |
| C-07 | DiscardSolutionUpdateで更新破棄 | E-01 (25行), E-02 (234-240行) | ○ |
| C-08 | DebuggingSessionがセッション管理の中核 | E-03 | ○ |
| C-09 | IManagedHotReloadServiceとデバッガー連携 | E-01 (27行), E-03 (108行) | ○ |
| C-10 | IPdbMatchingSourceTextProviderでPDBマッチング | E-01 (27行), E-03 (37行) | ○ |
| C-11 | コミット済みソリューションを管理 | E-03 (106行) | ○ |
| C-12 | Rude Editは適用不可能な変更パターン | E-03 (507-515行) | ○ |
| C-13 | アクティブステートメントの追跡 | E-01 (31-32行), E-03 (689-843行) | ○ |
| C-14 | ベースライン管理で累積的デルタ適用 | E-03 (53-76行, 308-367行) | ○ |
| C-15 | モジュール更新情報を出力 | E-01 (22行), E-03 (575-584行) | ○ |
| C-16 | 再起動が必要なプロジェクトを出力 | E-03 (581行) | ○ |
| C-17 | 再ビルドが必要なプロジェクトを出力 | E-03 (582行) | ○ |
| C-18 | ファイル読み取りエラー時のエラー処理 | E-03 (283-297, 421-427行) | ○ |
| C-19 | テレメトリデータの収集 | E-03 (115-116, 922-926行) | ○ |
| C-20 | C#とVB用に個別実装 | E-01 (インターフェース), 実装はLanguage固有 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
- [ ] Rude Edit種別の網羅性を確認（RudeEditKind.csと比較）
