---
generated_at: 2026-02-10 13:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：83-デバッグ機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件50ms**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/Debugging/ILanguageDebugInfoService.cs`
- E-02: `src/Features/Core/Portable/Debugging/AbstractBreakpointResolver.cs`
- E-03: `src/Features/Core/Portable/Debugging/IBreakpointResolutionService.cs`
- E-04: `src/Features/Core/Portable/Debugging/DebugDataTipInfo.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ブレークポイント解決、データTip情報、近傍式取得を提供 | E-05 (84行), E-01, E-03 | ○ |
| C-02 | ILanguageDebugInfoServiceがGetLocationInfoAsyncを定義 | E-01 (13行) | ○ |
| C-03 | ILanguageDebugInfoServiceがGetDataTipInfoAsyncを定義 | E-01 (22行) | ○ |
| C-04 | AbstractBreakpointResolverがDoAsyncでブレークポイント解決 | E-02 (89-120行) | ○ |
| C-05 | FindMembersAsyncでシンボル検索 | E-02 (122-156行) | ○ |
| C-06 | IsApplicableで適用可能性判定 | E-02 (241-281行) | ○ |
| C-07 | メソッド本体がある場所のみブレークポイント設定可能 | E-02 (272-273行) | ○ |
| C-08 | 抽象メソッドはブレークポイント対象外 | E-02 (251-254行) | ○ |
| C-09 | ソースがある位置のみ対象 | E-02 (270行) | ○ |
| C-10 | パラメータ数マッチングを実施 | E-02 (257-266行) | ○ |
| C-11 | BreakpointResolutionResultを返却 | E-02 (78-86行) | ○ |
| C-12 | C#とVB用に個別実装が必要 | E-01, E-02 (抽象メソッド) | ○ |
| C-13 | includeKindパラメータでKind計算を制御可能 | E-01 (21行) | ○ |
| C-14 | varキーワードで推論型名を返す | E-01 (18行コメント) | ○ |
| C-15 | パフォーマンス要件50ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（50ms）は明示的なドキュメントやコード上の定義が確認できない
  - 候補：パフォーマンステスト / UX設計ドキュメント / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから根拠を得られている
- パフォーマンス要件のみ根拠不明だが、機能動作には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] C-15のパフォーマンス要件について、適切な数値かどうか確認
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
