---
generated_at: 2026-02-10 13:41:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-スタックトレース探索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/StackTraceExplorer/StackTraceExplorerService.cs`
- E-02: `src/Features/Core/Portable/StackTraceExplorer/StackTraceAnalyzer.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スタックトレーステキストを解析しナビゲーションを提供 | E-03 (86行), E-01, E-02 | ○ |
| C-02 | AnalyzeAsyncでテキストを解析 | E-02 (26-29行) | ○ |
| C-03 | 複数のパーサーを順に試行 | E-02 (24行, 58-64行) | ○ |
| C-04 | DotnetStackFrameParser、VSDebugCallstackParser、DefaultStackParserの順 | E-02 (24行) | ○ |
| C-05 | HTMLデコードを適用 | E-02 (40行) | ○ |
| C-06 | GetDocumentAndLineでファイルと行番号を取得 | E-01 (27-41行) | ○ |
| C-07 | TryFindDefinitionAsyncでシンボル定義を検索 | E-01 (43-73行) | ○ |
| C-08 | RemoteHostClient利用可能時はリモートサービス呼び出し | E-01 (50-70行) | ○ |
| C-09 | 完全パス一致を先に試行 | E-01 (88行) | ○ |
| C-10 | ファイル名のみで検索フォールバック | E-01 (96行) | ○ |
| C-11 | 解析できない行はIgnoredFrameとして処理 | E-02 (DefaultStackParser使用) | ○ |
| C-12 | ParsedStackFrameに解析結果を格納 | E-02 (62行) | ○ |
| C-13 | VirtualCharSequenceでテキスト処理 | E-02 (42行) | ○ |
| C-14 | SplitLinesで行分割 | E-02 (44行, 71-89行) | ○ |
| C-15 | Trimで空白除去 | E-02 (51行, 92-112行) | ○ |
| C-16 | StackTraceAnalysisResultで結果を返却 | E-02 (28行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
- [ ] 各パーサーがサポートするスタックトレース形式を確認
