---
generated_at: 2026-02-10 13:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-値追跡

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ValueTracking/ValueTrackingService.cs`
- E-02: `src/Features/Core/Portable/ValueTracking/ValueTracker.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 変数やパラメータの値の由来を追跡する機能 | E-03 (87行), E-02 | ○ |
| C-02 | TrackValueSourceAsyncで初期追跡 | E-01 (27-55行), E-02 (19-71行) | ○ |
| C-03 | GetSelectedSymbolAsyncでシンボル取得 | E-02 (25行) | ○ |
| C-04 | プロパティ、フィールド、ローカル変数、パラメータが対象 | E-02 (28-33行) | ○ |
| C-05 | TrackVariableDefinitionsAsyncで初期化子収集 | E-02 (284-319行) | ○ |
| C-06 | TrackVariableReferencesAsyncで代入収集 | E-02 (164-172行) | ○ |
| C-07 | 左辺値への代入のみ追跡 | E-02 (57行) | ○ |
| C-08 | Ref/Outパラメータは特別処理 | E-02 (114行) | ○ |
| C-09 | 親パラメータは再追跡しない | E-02 (108行) | ○ |
| C-10 | TrackParameterSymbolAsyncでパラメータ追跡 | E-02 (174-186行) | ○ |
| C-11 | TrackMethodSymbolAsyncでメソッド戻り値追跡 | E-02 (188-253行) | ○ |
| C-12 | RemoteHostClient使用判定 | E-01 (33-34行) | ○ |
| C-13 | ローカル処理フォールバック | E-01 (52-54行) | ○ |
| C-14 | SymbolFinder.FindReferencesAsyncを使用 | E-02 (167-171行, 181-185行) | ○ |
| C-15 | 戻り値追跡でHasAValueReturnチェック | E-02 (198行, 244-247行) | ○ |
| C-16 | Out/Refパラメータも追跡対象 | E-02 (230-240行) | ○ |
| C-17 | ValueTrackingProgressCollectorで結果収集 | E-01 (52行), E-02 (26行) | ○ |
| C-18 | FunctionId.ValueTracking_TrackValueSourceでログ | E-01 (32行, 62行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
- [ ] OperationCollectorの詳細な動作を確認
