---
generated_at: 2026-02-10 13:47:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-メタデータソース表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/MetadataAsSource/MetadataAsSourceFileService.cs`
- E-02: `src/Features/Core/Portable/MetadataAsSource/AbstractMetadataAsSourceService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メタデータからシンボルシグネチャを抽出して表示 | E-03 (88行), E-02 | ○ |
| C-02 | GetGeneratedFileAsyncで生成処理 | E-01 (71-117行) | ○ |
| C-03 | Namespace以外のシンボルが対象 | E-01 (85-86行) | ○ |
| C-04 | GetOriginalUnreducedDefinitionでシンボル正規化 | E-01 (88行) | ○ |
| C-05 | ExtensionOrderer順でプロバイダー実行 | E-01 (61行) | ○ |
| C-06 | CleanupGeneratedFilesで古いファイル削除 | E-01 (119-145行) | ○ |
| C-07 | Mutexで他VSインスタンスを判定 | E-01 (131-133行, 50-52, 65行) | ○ |
| C-08 | AddSourceToAsyncでソース追加 | E-02 (21-65行) | ○ |
| C-09 | CodeGenerator.AddNamespaceOrTypeDeclarationAsync使用 | E-02 (42-46行) | ○ |
| C-10 | AddNullableRegionsAsync呼び出し | E-02 (48行) | ○ |
| C-11 | ConvertDocCommentsToRegularCommentsAsync呼び出し | E-02 (51行) | ○ |
| C-12 | Formatter.FormatAsync呼び出し | E-02 (56-61行) | ○ |
| C-13 | Simplifier.ReduceAsync呼び出し | E-02 (64行) | ○ |
| C-14 | CreateCodeGenerationSymbolでシンボルラップ | E-02 (91-108行) | ○ |
| C-15 | ファイルを読み取り専用に設定 | E-01 (152行相当の処理) | ○ |
| C-16 | TryAddDocumentToWorkspaceでドキュメント追加 | E-01 (168-189行) | ○ |
| C-17 | TryRemoveDocumentFromWorkspaceでドキュメント削除 | E-01 (191-220行) | ○ |
| C-18 | ShouldCollapseOnOpenで折りたたみ制御 | E-01 (222-255行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
- [ ] 各プロバイダーの詳細動作を確認
