---
generated_at: 2026-02-10 13:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-逆コンパイルソース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/DecompiledSource/IDecompiledSourceService.cs`
- E-02: `src/Features/Core/Portable/MetadataAsSource/MetadataAsSourceFileService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ILを逆コンパイルしてソースコードを復元 | E-03 (89行), E-01 | ○ |
| C-02 | IDecompiledSourceService.AddSourceToAsyncでソース追加 | E-01 (26行) | ○ |
| C-03 | document, symbolCompilation, symbol等がパラメータ | E-01 (26行) | ○ |
| C-04 | 戻り値がDocument?でnull許容 | E-01 (26行) | ○ |
| C-05 | プロバイダーチェーンで使用 | E-02 (106-113行) | ○ |
| C-06 | PdbSourceDocumentProvider → DecompiledSourceProvider → MetadataAsSourceProviderの順 | E-02 (61行, 106-113行) | ○ |
| C-07 | 逆コンパイル失敗時はフォールバック | E-02 (111-112行) | ○ |
| C-08 | metadataReferenceパラメータが存在 | E-01 (26行) | ○ |
| C-09 | assemblyLocationパラメータが存在 | E-01 (26行) | ○ |
| C-10 | formattingOptionsでフォーマット制御 | E-01 (26行) | ○ |
| C-11 | ICSharpCode.Decompilerを使用 | E-03 (89行説明) | ○ |
| C-12 | 言語サービスとして実装 | E-01 (ILanguageService) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] ICSharpCode.Decompilerの詳細な使用方法を確認
- [ ] C#以外の言語（VB等）での逆コンパイルサポート状況を確認
