---
generated_at: 2026-02-10 13:56:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-Language Server Protocol

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/LanguageServer/Protocol/Handler/Hover/HoverHandler.cs`
- E-02: `src/LanguageServer/Protocol/Handler/Completion/CompletionHandler.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LSP仕様に準拠したサーバーを実装 | E-03 (91行), E-01, E-02 | ○ |
| C-02 | HoverHandler.HandleRequestAsyncでホバー処理 | E-01 (42-52行) | ○ |
| C-03 | GetTextDocumentIdentifierでドキュメント特定 | E-01 (40行) | ○ |
| C-04 | context.GetRequiredDocument()でドキュメント取得 | E-01 (44行) | ○ |
| C-05 | QuickInfoService.GetQuickInfoAsyncを使用 | E-01 (97行) | ○ |
| C-06 | CompletionHandler.HandleRequestAsyncで補完処理 | E-02 (45-67行) | ○ |
| C-07 | CompletionService.GetCompletionsAsyncを使用 | E-02 (174行) | ○ |
| C-08 | ProtocolConversions.PositionToLinePositionで変換 | E-01 (47行), E-02 (53行) | ○ |
| C-09 | MutatesSolutionStateでステート変更を宣言 | E-01 (37行), E-02 (32行) | ○ |
| C-10 | RequiresLSPSolutionでソリューション要件を宣言 | E-01 (38行), E-02 (33行) | ○ |
| C-11 | ClientCapabilitiesでクライアント機能を確認 | E-01 (45, 48-49行) | ○ |
| C-12 | ExportCSharpVisualBasicStatelessLspServiceでエクスポート | E-01 (24行), E-02 (26行) | ○ |
| C-13 | Methodアトリビュートでハンドラー登録 | E-01 (25行), E-02 (27行) | ○ |
| C-14 | VSInternalHoverでVS拡張レスポンス | E-01 (106行) | ○ |
| C-15 | MarkupKind.Markdownサポート確認 | E-01 (49行) | ○ |
| C-16 | CompletionListCacheでキャッシュ管理 | E-02 (57, 182行) | ○ |
| C-17 | CompletionCapabilityHelperでクライアント機能ラップ | E-02 (56, 78行) | ○ |
| C-18 | IGlobalOptionServiceでオプション取得 | E-01 (28-29, 34行), E-02 (30-31, 40行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローの説明が実装と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新コードと一致するか確認
- [ ] LSP 3.17仕様との互換性を確認
- [ ] VS拡張（VSInternal）の詳細を確認
