---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：91-共通LSPフレームワーク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：具体的な数値の根拠不足
  2. **NuGet パッケージ名**：公開パッケージ名の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractLanguageServer.cs`
- E-02: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/RequestExecutionQueue.cs`
- E-03: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/IRequestHandler.cs`
- E-04: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/HandlerProvider.cs`
- E-05: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/RequestHandlerMetadata.cs`
- E-06: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/ILifeCycleManager.cs`
- E-07: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/README.md`
- E-08: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/LspErrorCodes.cs`
- E-09: 機能一覧.csv（No.91 共通LSPフレームワーク）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JSON-RPC を介したクライアント-サーバー通信 | E-01: 22-23行目 JsonRpc フィールド、StreamJsonRpc 使用 | ○ |
| C-02 | リクエストのキューイングと実行管理 | E-02: 55-68行目 RequestExecutionQueue クラス定義 | ○ |
| C-03 | ハンドラーの登録と管理 | E-04: HandlerProvider クラス | ○ |
| C-04 | IRequestHandler インターフェースの定義 | E-03: 13-23行目 HandleRequestAsync メソッド | ○ |
| C-05 | ミューテーティングリクエストの直列化 | E-02: 354行目 handler.MutatesSolutionState 判定 | ○ |
| C-06 | 非ミューテーティングリクエストの並列実行 | E-02: 379-381行目 Task.Run による並列実行 | ○ |
| C-07 | サーバー初期化フロー | E-01: 88-91行目 Initialize() メソッド | ○ |
| C-08 | SetupRequestDispatcher でエントリーポイント登録 | E-01: 110-157行目 SetupRequestDispatcher メソッド | ○ |
| C-09 | shutdown/exit ハンドラー | E-01: 159-163行目 HandleShutdownRequestAsync, HandleExitNotificationAsync | ○ |
| C-10 | ShutdownAsync でキュー停止 | E-01: 246-271行目 ShutdownAsync メソッド | ○ |
| C-11 | ExitAsync でリソース解放 | E-01: 277-325行目 ExitAsync メソッド | ○ |
| C-12 | キャンセル伝播機能 | E-02: 166-167行目 CancellationTokenSource.CombineWith | ○ |
| C-13 | 言語ルーティング機能 | E-01: 185-189行目 TryGetLanguageForRequest | ○ |
| C-14 | Lazy 初期化パターン | E-01: 29-31行目 Lazy<> フィールド | ○ |
| C-15 | ExecuteAsync でキュー追加 | E-02: 156-188行目 ExecuteAsync メソッド | ○ |
| C-16 | ProcessQueueAsync でキュー処理 | E-02: 190-303行目 ProcessQueueAsync メソッド | ○ |
| C-17 | ProcessQueueCoreAsync でハンドラー実行 | E-02: 332-406行目 ProcessQueueCoreAsync メソッド | ○ |
| C-18 | CancelInProgressWorkUponMutatingRequest オプション | E-02: 144行目 protected virtual プロパティ | ○ |
| C-19 | LSP エラーコード定義 | E-08: LspErrorCodes クラス | ○ |
| C-20 | ライフサイクル管理インターフェース | E-06: ILifeCycleManager インターフェース | ○ |
| C-21 | TypeRef による型解決 | E-01: 57行目 TypeRefResolver プロパティ | ○ |
| C-22 | FrozenDictionary によるハンドラーマップ | E-02: 76行目 _handlerInfoMap フィールド | ○ |
| C-23 | README.md による概要説明 | E-07: README.md ファイル存在 | ○ |
| C-24 | パフォーマンス要件（100ms、200ms） | **根拠なし** | △ |
| C-25 | NuGet パッケージ名 Microsoft.CommonLanguageServerProtocol.Framework | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体値**：ソースコードに具体的なパフォーマンス要件は定義されていない。一般的な LSP の期待値として記載したが、公式仕様書の確認が必要。
  - 候補：LSP 仕様書 / プロジェクト要件定義書 / パフォーマンステスト結果
- **NuGet パッケージ名**：プロジェクトファイル(.csproj)は存在するが、公開パッケージ名の確認はパッケージリポジトリで必要。
  - 候補：nuget.org / プロジェクトの csproj ファイル / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアロジックの説明（E-01, E-02 から確認可能）
- 0: 低リスク - インターフェース定義の説明
- 1: 中リスク - パフォーマンス要件は推定値のため、実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractLanguageServer の Initialize/Shutdown/Exit フローが正確に記載されているか
- [ ] RequestExecutionQueue のミューテーティング/非ミューテーティング処理の区別が正しいか
- [ ] エラーコード一覧が LSP 仕様と整合しているか
- [ ] パフォーマンス要件の数値が妥当か（または削除すべきか）
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
