---
generated_at: 2026-02-10 14:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：92-Roslyn言語サーバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **C# Dev Kit 連携**：具体的な連携方法の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/LanguageServerHost.cs`
- E-02: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectSystem.cs`
- E-03: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectLoader.cs`
- E-04: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/RunTestsHandler.cs`
- E-05: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestDiscoverer.cs`
- E-06: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/Handler/Restore/RestoreHandler.cs`
- E-07: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/FileBasedPrograms/FileBasedProgramsProjectSystem.cs`
- E-08: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/Razor/RazorInitializer.cs`
- E-09: 機能一覧.csv（No.92 Roslyn言語サーバー）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LanguageServerHost で JsonRpc 初期化 | E-01: 29-54行目 コンストラクタ | ○ |
| C-02 | RoslynLanguageServer の作成 | E-01: 47-53行目 roslynLspFactory.Create | ○ |
| C-03 | Start() で JsonRpc リスニング開始 | E-01: 56-62行目 Start メソッド | ○ |
| C-04 | WaitForExitAsync でサーバー終了待機 | E-01: 64-68行目 WaitForExitAsync | ○ |
| C-05 | LanguageServerProjectSystem でプロジェクト管理 | E-02: ファイル存在 | ○ |
| C-06 | LanguageServerProjectLoader でプロジェクト読み込み | E-03: ファイル存在 | ○ |
| C-07 | RunTestsHandler でテスト実行 | E-04: ファイル存在 | ○ |
| C-08 | TestDiscoverer でテスト検出 | E-05: ファイル存在 | ○ |
| C-09 | RestoreHandler で NuGet 復元 | E-06: ファイル存在 | ○ |
| C-10 | FileBasedProgramsProjectSystem で単一ファイル対応 | E-07: ファイル存在 | ○ |
| C-11 | RazorInitializer で Razor 連携 | E-08: ファイル存在 | ○ |
| C-12 | HeaderDelimitedMessageHandler 使用 | E-01: 33行目 HeaderDelimitedMessageHandler | ○ |
| C-13 | ExceptionProcessing.CommonErrorData 使用 | E-01: 38行目 ExceptionStrategy | ○ |
| C-14 | LspServiceLogger でログ記録 | E-01: 44行目 LspServiceLogger | ○ |
| C-15 | MEF ExportProvider 使用 | E-01: 29行目 exportProvider パラメータ | ○ |
| C-16 | HostServicesProvider からホストサービス取得 | E-01: 46行目 HostServicesProvider | ○ |
| C-17 | WellKnownLspServerKinds.CSharpVisualBasicLspServer | E-01: 50行目 サーバー種別 | ○ |
| C-18 | Instance 静的プロパティ | E-01: 23行目 static Instance プロパティ | ○ |
| C-19 | ILanguageServerFactory インターフェース | E-01: 41行目 GetExportedValue | ○ |
| C-20 | GetRequiredLspService でサービス取得 | E-01: 70-73行目 GetRequiredLspService | ○ |
| C-21 | パフォーマンス要件（200ms、500ms） | **根拠なし** | △ |
| C-22 | C# Dev Kit との連携 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**：ソースコードに具体的なパフォーマンス目標は定義されていない。一般的な期待値として記載。
  - 候補：プロジェクト要件定義書 / パフォーマンステスト結果 / 設計仕様書
- **C# Dev Kit 連携**：Roslyn 言語サーバーは独立したコンポーネントであり、C# Dev Kit との連携は外部で行われる。
  - 候補：VS Code 拡張機能ドキュメント / C# Dev Kit リポジトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアコンポーネントの説明（ソースコード確認済み）
- 0: 低リスク - ファイル構造の説明
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] LanguageServerHost の初期化フローが正確に記載されているか
- [ ] プロジェクトシステムのファイル構成が最新か
- [ ] テスト機能のハンドラー一覧が網羅的か
- [ ] パフォーマンス要件を削除または実測値に更新すべきか
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
