---
generated_at: 2026-02-10 14:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：93-CodeLens

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Features/Core/Portable/CodeLens/CodeLensReferencesService.cs`
- E-02: `src/Features/Core/Portable/CodeLens/ICodeLensReferencesService.cs`
- E-03: `src/Features/Core/Portable/CodeLens/ReferenceCount.cs`
- E-04: `src/Features/Core/Portable/CodeLens/ReferenceLocationDescriptor.cs`
- E-05: `src/Features/Core/Portable/CodeLens/ReferenceMethodDescriptor.cs`
- E-06: `src/Features/Core/Portable/CodeLens/CodeLensFindReferenceProgress.cs`
- E-07: 機能一覧.csv（No.93 CodeLens）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SymbolFinder.FindReferencesAsync で参照検索 | E-01: 66-67行目 SymbolFinder.FindReferencesAsync | ○ |
| C-02 | 非並列検索設定 Explicit = false | E-01: 39行目 Explicit = false | ○ |
| C-03 | 単方向継承カスケード UnidirectionalHierarchyCascade = true | E-01: 40行目 UnidirectionalHierarchyCascade = true | ○ |
| C-04 | searchCap パラメータによる上限設定 | E-01: 45行目 searchCap パラメータ | ○ |
| C-05 | GetReferenceCountAsync メソッド | E-01: 90-100行目 GetReferenceCountAsync | ○ |
| C-06 | FindReferenceLocationsAsync メソッド | E-01: 198-211行目 FindReferenceLocationsAsync | ○ |
| C-07 | FindReferenceMethodsAsync メソッド | E-01: 370-384行目 FindReferenceMethodsAsync | ○ |
| C-08 | GetProjectCodeLensVersionAsync でバージョン取得 | E-01: 85-88行目 GetProjectCodeLensVersionAsync | ○ |
| C-09 | ReferenceCount データ構造 | E-03: ファイル存在 | ○ |
| C-10 | ReferenceLocationDescriptor データ構造 | E-04: ファイル存在 | ○ |
| C-11 | ReferenceMethodDescriptor データ構造 | E-05: ファイル存在 | ○ |
| C-12 | CodeLensFindReferencesProgress で進捗管理 | E-06: ファイル存在 | ○ |
| C-13 | MethodDisplayFormat の定義 | E-01: 25-27行目 MethodDisplayFormat | ○ |
| C-14 | IsCapped フラグ | E-01: 98行目 IsCapped: true | ○ |
| C-15 | GetDescriptorOfEnclosingSymbolAsync メソッド | E-01: 102-164行目 GetDescriptorOfEnclosingSymbolAsync | ○ |
| C-16 | TryGetMethodDescriptorAsync メソッド | E-01: 356-368行目 TryGetMethodDescriptorAsync | ○ |
| C-17 | GetFullyQualifiedNameAsync メソッド | E-01: 386-450行目 GetFullyQualifiedNameAsync | ○ |
| C-18 | MapReferenceLocationsAsync メソッド | E-01: 213-285行目 MapReferenceLocationsAsync | ○ |
| C-19 | GetEnclosingCodeElementNode メソッド | E-01: 166-196行目 GetEnclosingCodeElementNode | ○ |
| C-20 | パフォーマンス要件（100ms、500ms） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**：ソースコードに具体的なパフォーマンス目標は定義されていない。
  - 候補：プロジェクト要件定義書 / パフォーマンステスト結果 / Visual Studio 仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアロジックの説明（ソースコード確認済み）
- 0: 低リスク - データ構造の説明
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] FindReferencesSearchOptions の設定が正確に記載されているか
- [ ] GetReferenceCountAsync/FindReferenceLocationsAsync/FindReferenceMethodsAsync の動作が正しいか
- [ ] データ構造（ReferenceCount, ReferenceLocationDescriptor, ReferenceMethodDescriptor）が正確か
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
