---
generated_at: 2026-02-10 14:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：94-継承マージン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Features/Core/Portable/InheritanceMargin/AbstractInheritanceMarginService.cs`
- E-02: `src/Features/Core/Portable/InheritanceMargin/InheritanceMarginItem.cs`
- E-03: `src/Features/Core/Portable/InheritanceMargin/InheritanceTargetItem.cs`
- E-04: `src/Features/Core/Portable/InheritanceMargin/IInheritanceMarginService.cs`
- E-05: `src/Features/Core/Portable/InheritanceMargin/IRemoteInheritanceMarginService.cs`
- E-06: `src/Features/Core/Portable/InheritanceMargin/InheritanceRelationship.cs`
- E-07: 画面機能マッピング.csv（画面No.53 継承マージンコンテキストメニュー）
- E-08: 機能一覧.csv（No.94 継承マージン）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetInheritanceMemberItemsAsync メソッド | E-01: 30-67行目 | ○ |
| C-02 | RemoteHostClient.TryInvokeAsync による OOP 呼び出し | E-01: 38-49行目 | ○ |
| C-03 | GetInheritanceMarginItemsInProcessAsync でインプロセス処理 | E-01: 60-66行目 | ○ |
| C-04 | CanHaveInheritanceTarget でシンボル判定 | E-01: 69-86行目 | ○ |
| C-05 | TypeKind が Interface, Class, Struct のみ対象 | E-01: 73行目 namedType.TypeKind | ○ |
| C-06 | MethodKind の判定 | E-01: 79行目 MethodKind 条件 | ○ |
| C-07 | IEventSymbol, IPropertySymbol も対象 | E-01: 76-77行目 | ○ |
| C-08 | static シンボルは除外 | E-01: 73行目 !symbol.IsStatic | ○ |
| C-09 | InheritanceMarginItem データ構造 | E-02: 14-78行目 readonly struct 定義 | ○ |
| C-10 | LineNumber プロパティ | E-02: 25行目 | ○ |
| C-11 | DisplayTexts プロパティ | E-02: 38行目 | ○ |
| C-12 | Glyph プロパティ | E-02: 44行目 | ○ |
| C-13 | TargetItems プロパティ | E-02: 50行目 | ○ |
| C-14 | CreateOrdered メソッド | E-02: 68-74行目 | ○ |
| C-15 | Order メソッドでソート | E-02: 76-77行目 OrderBy, ThenByDescending, ThenBy | ○ |
| C-16 | 画面機能マッピング（継承マージンコンテキストメニュー） | E-07: 画面No.53 | ○ |
| C-17 | frozenPartialSemantics パラメータ | E-01: 34行目 | ○ |
| C-18 | パフォーマンス要件（10ms） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**：ソースコードに具体的なパフォーマンス目標は定義されていない。
  - 候補：Visual Studio パフォーマンスガイドライン / プロジェクト要件

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアロジックの説明（ソースコード確認済み）
- 0: 低リスク - データ構造の説明
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] CanHaveInheritanceTarget の判定ロジックが正確に記載されているか
- [ ] InheritanceMarginItem の構造が正確か
- [ ] OOP/インプロセスのフォールバック動作が正しいか
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
