---
generated_at: 2026-02-10 14:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：95-C#スクリプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **NuGet パッケージ名**：公開パッケージ名の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Scripting/CSharp/CSharpScript.cs`
- E-02: `src/Scripting/Core/Script.cs`
- E-03: `src/Scripting/Core/ScriptOptions.cs`
- E-04: `src/Scripting/Core/ScriptState.cs`
- E-05: `src/Scripting/CSharp/CSharpScriptCompiler.cs`
- E-06: `src/Scripting/Core/ScriptBuilder.cs`
- E-07: 機能一覧.csv（No.95 C#スクリプト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSharpScript.Create<T> メソッド | E-01: 33-38行目 | ○ |
| C-02 | Stream 入力対応 | E-01: 50-55行目 | ○ |
| C-03 | RunAsync<T> メソッド | E-01: 98-101行目 | ○ |
| C-04 | EvaluateAsync<T> メソッド | E-01: 128-131行目 | ○ |
| C-05 | CSharpScriptCompiler.Instance 使用 | E-01: 37行目 | ○ |
| C-06 | SourceText.From でソーステキスト作成 | E-01: 37行目 | ○ |
| C-07 | Script.CreateInitialScript<T> 呼び出し | E-01: 37行目 | ○ |
| C-08 | Script コンストラクタ | E-02: 39-52行目 | ○ |
| C-09 | GetCompilation メソッド | E-02: 144-153行目 | ○ |
| C-10 | ContinueWith<TResult> メソッド | E-02: 114-118行目 | ○ |
| C-11 | Compile メソッド | E-02: 231-234行目 | ○ |
| C-12 | Script<T>.GetExecutor メソッド | E-02: 387-395行目 | ○ |
| C-13 | ValidateGlobals メソッド | E-02: 586-606行目 | ○ |
| C-14 | RunSubmissionsAsync メソッド | E-02: 574-584行目 | ○ |
| C-15 | Previous プロパティ | E-02: 64行目 | ○ |
| C-16 | ScriptOptions.Default | E-03: 25-37行目 | ○ |
| C-17 | MetadataReferences プロパティ | E-03: 88行目 | ○ |
| C-18 | Imports プロパティ | E-03: 103行目 | ○ |
| C-19 | AllowUnsafe プロパティ | E-03: 134行目 | ○ |
| C-20 | InheritOptions メソッド | E-02: 133-139行目 | ○ |
| C-21 | catchException パラメータ | E-02: 194-195行目 | ○ |
| C-22 | ScriptState 戻り値 | E-04: ファイル存在 | ○ |
| C-23 | CompilationErrorException | E-02: 368-371行目 | ○ |
| C-24 | NuGet パッケージ名 Microsoft.CodeAnalysis.CSharp.Scripting | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **NuGet パッケージ名**：プロジェクトファイル(.csproj)は存在するが、公開パッケージ名の確認はパッケージリポジトリで必要。
  - 候補：nuget.org / プロジェクトの csproj ファイル / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアロジックの説明（ソースコード確認済み）
- 0: 低リスク - API 説明
- 0: 低リスク - データフローの説明

## 6) レビュアーチェックリスト（最小）
- [ ] CSharpScript.Create の各オーバーロードが正確に記載されているか
- [ ] Script<T> のライフサイクル（作成→コンパイル→実行→継続）が正しいか
- [ ] ScriptOptions のプロパティ一覧が網羅的か
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
