---
generated_at: 2026-02-10 14:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：96-VBスクリプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **NuGet パッケージ名**：公開パッケージ名の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Scripting/VisualBasic/VisualBasicScript.vb`
- E-02: `src/Scripting/VisualBasic/VisualBasicScriptCompiler.vb`
- E-03: `src/Scripting/Core/Script.cs`
- E-04: 機能一覧.csv（No.96 VBスクリプト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VisualBasicScript.Create(Of T) メソッド | E-01: 22-27行目 | ○ |
| C-02 | VisualBasicScript.Create メソッド（Object型） | E-01: 32-37行目 | ○ |
| C-03 | VisualBasicScript.RunAsync(Of T) メソッド | E-01: 42-47行目 | ○ |
| C-04 | VisualBasicScript.RunAsync メソッド（Object型） | E-01: 52-57行目 | ○ |
| C-05 | VisualBasicScript.EvaluateAsync(Of T) メソッド | E-01: 62-67行目 | ○ |
| C-06 | VisualBasicScript.EvaluateAsync メソッド（Object型） | E-01: 72-77行目 | ○ |
| C-07 | VisualBasicScriptCompiler.Instance 使用 | E-01: 26行目 | ○ |
| C-08 | Script.CreateInitialScript 呼び出し | E-01: 26行目 | ○ |
| C-09 | SourceText.From 使用 | E-01: 26行目 | ○ |
| C-10 | If(code, String.Empty) によるnull対応 | E-01: 26行目 | ○ |
| C-11 | Optional パラメータ使用 | E-01: 23-26行目 | ○ |
| C-12 | 共通 Script 基底クラス使用 | E-03: Script クラス定義 | ○ |
| C-13 | GetEvaluationResultAsync 使用 | E-01: 66行目 | ○ |
| C-14 | NotInheritable Class 定義 | E-01: 15行目 | ○ |
| C-15 | NuGet パッケージ名 Microsoft.CodeAnalysis.VisualBasic.Scripting | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **NuGet パッケージ名**：プロジェクトファイル(.vbproj)は存在するが、公開パッケージ名の確認はパッケージリポジトリで必要。
  - 候補：nuget.org / プロジェクトの vbproj ファイル / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアロジックの説明（ソースコード確認済み）
- 0: 低リスク - API 説明

## 6) レビュアーチェックリスト（最小）
- [ ] VisualBasicScript の各メソッドシグネチャが正確か
- [ ] C# スクリプトとの差異が正しく説明されているか
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
