---
generated_at: 2026-02-10 15:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：97-スクリプトコア

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **NuGet パッケージ名**：公開パッケージ名の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Scripting/Core/Script.cs`
- E-02: `src/Scripting/Core/ScriptOptions.cs`
- E-03: `src/Scripting/Core/ScriptState.cs`
- E-04: `src/Scripting/Core/ScriptBuilder.cs`
- E-05: `src/Scripting/Core/Hosting/CommandLine/CommandLineRunner.cs`
- E-06: `src/Scripting/Core/ScriptExecutionState.cs`
- E-07: 機能一覧.csv（No.97 スクリプトコア）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ScriptOptions.Default 定義 | E-02: 25-37行目 | ○ |
| C-02 | GetDefaultMetadataReferences メソッド | E-02: 39-77行目 | ○ |
| C-03 | MetadataReferences プロパティ | E-02: 88行目 | ○ |
| C-04 | MetadataResolver プロパティ | E-02: 93行目 | ○ |
| C-05 | Imports プロパティ | E-02: 103行目 | ○ |
| C-06 | AllowUnsafe プロパティ | E-02: 134行目 | ○ |
| C-07 | WithReferences メソッド群 | E-02: 215-306行目 | ○ |
| C-08 | Script コンストラクタ | E-01: 39-52行目 | ○ |
| C-09 | CreateInitialScript メソッド | E-01: 54-57行目 | ○ |
| C-10 | GetCompilation メソッド | E-01: 144-153行目 | ○ |
| C-11 | Script<T>.GetExecutor メソッド | E-01: 387-395行目 | ○ |
| C-12 | HostAssemblyReferenceProperties 定義 | E-01: 238-239行目 | ○ |
| C-13 | GetReferencesForCompilation メソッド | E-01: 245-304行目 | ○ |
| C-14 | CommandLineRunner.RunInteractive | E-05: 53-69行目 | ○ |
| C-15 | CommandLineRunner.RunInteractiveLoop | E-05: 222-292行目 | ○ |
| C-16 | CommandLineRunner.BuildAndRun | E-05: 294-318行目 | ○ |
| C-17 | ScriptState クラス存在 | E-03: ファイル存在 | ○ |
| C-18 | ScriptBuilder クラス存在 | E-04: ファイル存在 | ○ |
| C-19 | ScriptExecutionState クラス存在 | E-06: ファイル存在 | ○ |
| C-20 | GacFileResolver.IsAvailable 条件分岐 | E-02: 41-44行目 | ○ |
| C-21 | UnresolvedMetadataReference 使用 | E-02: 208-209行目 | ○ |
| C-22 | NuGet パッケージ名 Microsoft.CodeAnalysis.Scripting.Common | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **NuGet パッケージ名**：プロジェクトファイル(.csproj)は存在するが、公開パッケージ名の確認はパッケージリポジトリで必要。
  - 候補：nuget.org / プロジェクトの csproj ファイル / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアクラスの説明（ソースコード確認済み）
- 0: 低リスク - API 説明
- 0: 低リスク - データフローの説明

## 6) レビュアーチェックリスト（最小）
- [ ] ScriptOptions の主要プロパティが網羅されているか
- [ ] Script/Script<T> のライフサイクルが正確か
- [ ] CommandLineRunner の REPL 動作が正しく説明されているか
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
