---
generated_at: 2026-02-10 12:50:00
metrics:
  claims_total: 60
  claims_with_evidence: 60
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：60 / 60、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml`
- E-02: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml`
- E-03: `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml`
- E-04: `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml`
- E-05: `src/VisualStudio/Core/Def/ExtractInterface/ExtractInterfaceDialog.xaml`
- E-06: `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml`
- E-07: `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml`
- E-08: `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml`
- E-09: `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml`
- E-10: `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml`
- E-11: `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml`
- E-12: `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelection.xaml`
- E-13: `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml`
- E-14: `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml`
- E-15: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml`
- E-16: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml`
- E-17: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml`
- E-18: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml`
- E-19: `src/VisualStudio/Core/Def/UnusedReferences/Dialog/RemoveUnusedReferencesDialog.xaml`
- E-20: `src/VisualStudio/Core/Def/PreviewPane/PreviewPane.xaml`
- E-21: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml`
- E-22: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml`
- E-23: `src/EditorFeatures/Core/InlineRename/UI/InlineRenameColors.xaml`
- E-24: `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameUserInputComboBox.xaml`
- E-25: `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameStatusControl.xaml`
- E-26: `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml`
- E-27: `src/VisualStudio/Core/Impl/Options/GridOptionPreviewControl.xaml`
- E-28: `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml`
- E-29: `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml`
- E-30: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml`
- E-31: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml`
- E-32: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml`
- E-33: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml`
- E-34: `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml`
- E-35: `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPageControl.xaml`
- E-36: `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml`
- E-37: `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml`
- E-38: `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceSettingsView.xaml`
- E-39: `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceBoolSettingView.xaml`
- E-40: `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSettingsView.xaml`
- E-41: `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleValueControl.xaml`
- E-42: `src/VisualStudio/Core/Def/EditorConfigSettings/CodeStyle/View/CodeStyleSeverityControl.xaml`
- E-43: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/NamingStyleSettingsView.xaml`
- E-44: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesTypeControl.xaml`
- E-45: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesStyleControl.xaml`
- E-46: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesSeverityControl.xaml`
- E-47: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesLocationControl.xaml`
- E-48: `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/AnalyzerSettingsView.xaml`
- E-49: `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml`
- E-50: `src/VisualStudio/Core/Def/EditorConfigSettings/Common/EnumPropertyView.xaml`
- E-51: `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml`
- E-52: `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml`
- E-53: `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginContextMenu.xaml`
- E-54: `src/VisualStudio/Core/Def/VSThemeDictionary.xaml`
- E-55: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/StatusIndicator.xaml`
- E-56: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferMargin.xaml`
- E-57: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/TelemetryPanel.xaml`
- E-58: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/Panels/WorkspacePanel.xaml`
- E-59: `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/App.xaml`
- E-60: `src/Workspaces/MSBuild/Test/Resources/SourceFiles/Xaml/MainWindow.xaml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シグネチャ変更ダイアログ - パラメータ変更用ダイアログ | E-01 | ○ |
| C-02 | パラメータ追加ダイアログ - 新パラメータ追加用 | E-02 | ○ |
| C-03 | 型生成ダイアログ - 新規型生成用 | E-03 | ○ |
| C-04 | クラス抽出ダイアログ - クラス抽出リファクタリング用 | E-04 | ○ |
| C-05 | インターフェース抽出ダイアログ - インターフェース抽出用 | E-05 | ○ |
| C-06 | 名前空間移動ダイアログ - 型の名前空間移動用 | E-06 | ○ |
| C-07 | メンバー引き上げダイアログ - 基底クラスへのメンバー移動用 | E-07 | ○ |
| C-08 | メンバー引き上げ警告ダイアログ - 警告表示用 | E-08 | ○ |
| C-09 | メンバー選択ダイアログ - 汎用メンバー選択用 | E-09 | ○ |
| C-10 | 静的メンバー移動ダイアログ - 静的メンバーの型間移動用 | E-10 | ○ |
| C-11 | 静的メンバー選択コントロール - 移動対象選択用 | E-11 | ○ |
| C-12 | 新規型作成先選択コントロール - 共通コントロール | E-12 | ○ |
| C-13 | メンバー選択コントロール - 共通コントロール | E-13 | ○ |
| C-14 | ドキュメントアウトラインビュー - シンボルツリー表示 | E-14 | ○ |
| C-15 | 値追跡ルートビュー - ツールウィンドウルート | E-15 | ○ |
| C-16 | 値追跡ツリービュー - 追跡結果表示 | E-16 | ○ |
| C-17 | スタックトレースエクスプローラールート - タブ管理 | E-17 | ○ |
| C-18 | スタックトレースエクスプローラー - フレーム表示 | E-18 | ○ |
| C-19 | 未使用参照削除ダイアログ - 参照削除用 | E-19 | ○ |
| C-20 | プレビューペイン - コード変更プレビュー | E-20 | ○ |
| C-21 | リネームフライアウト - インラインリネームUI | E-21 | ○ |
| C-22 | リネームユーザー入力テキストボックス - 名前入力用 | E-22 | ○ |
| C-23 | インラインリネームカラー定義 - 色定義リソース | E-23 | ○ |
| C-24 | スマートリネームコンボボックス - AI候補表示 | E-24 | ○ |
| C-25 | スマートリネームステータス - 状態表示 | E-25 | ○ |
| C-26 | オンザフライドキュメントビュー - 動的ドキュメント表示 | E-26 | ○ |
| C-27 | グリッドオプションプレビュー - コードスタイル設定 | E-27 | ○ |
| C-28 | オプションプレビューコントロール - プレビュー表示 | E-28 | ○ |
| C-29 | コードスタイル通知テキストブロック - 警告表示 | E-29 | ○ |
| C-30 | 命名スタイルオプションページ - 命名規則設定 | E-30 | ○ |
| C-31 | 命名スタイルダイアログ - スタイル編集 | E-31 | ○ |
| C-32 | シンボル仕様ダイアログ - 仕様編集 | E-32 | ○ |
| C-33 | 命名スタイル管理ダイアログ - スタイル管理 | E-33 | ○ |
| C-34 | C#詳細オプション - 言語固有設定 | E-34 | ○ |
| C-35 | C#書式設定オプション - 書式設定 | E-35 | ○ |
| C-36 | VB詳細オプション - VB固有設定 | E-36 | ○ |
| C-37 | 設定エディタコントロール - EditorConfig編集 | E-37 | ○ |
| C-38 | 空白設定ビュー - インデント等設定 | E-38 | ○ |
| C-39 | 空白ブール設定ビュー - ブール値設定 | E-39 | ○ |
| C-40 | コードスタイル設定ビュー - スタイル一覧 | E-40 | ○ |
| C-41 | コードスタイル値コントロール - 値選択 | E-41 | ○ |
| C-42 | コードスタイル重大度コントロール - 重大度選択 | E-42 | ○ |
| C-43 | 命名スタイル設定ビュー - 命名規則一覧 | E-43 | ○ |
| C-44 | 命名スタイルタイプコントロール - シンボル種類表示 | E-44 | ○ |
| C-45 | 命名スタイルスタイルコントロール - スタイル表示 | E-45 | ○ |
| C-46 | 命名スタイル重大度コントロール - 重大度表示 | E-46 | ○ |
| C-47 | 命名スタイル場所コントロール - 場所表示 | E-47 | ○ |
| C-48 | アナライザー設定ビュー - アナライザー一覧 | E-48 | ○ |
| C-49 | 重大度コントロール - アナライザー重大度 | E-49 | ○ |
| C-50 | 列挙プロパティビュー - 共通ビュー | E-50 | ○ |
| C-51 | タブコントロールスタイル - スタイル定義 | E-51 | ○ |
| C-52 | 詳細エラー情報ダイアログ - エラー詳細表示 | E-52 | ○ |
| C-53 | 継承マージンコンテキストメニュー - 継承ナビゲーション | E-53 | ○ |
| C-54 | VSテーマ辞書 - テーマリソース | E-54 | ○ |
| C-55 | ステータスインジケーター - パフォーマンス表示 | E-55 | ○ |
| C-56 | プロジェクションバッファマージン - 診断表示 | E-56 | ○ |
| C-57 | テレメトリパネル - テレメトリ情報 | E-57 | ○ |
| C-58 | ワークスペースパネル - ワークスペース情報 | E-58 | ○ |
| C-59 | App.xaml（テスト用） - テストリソース | E-59 | ○ |
| C-60 | MainWindow.xaml（テスト用） - テストリソース | E-60 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての画面項目はXAMLファイルから直接抽出しているため、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 本ドキュメントはプロジェクト内のXAMLファイルを直接解析して生成しているため、信頼性が高いです。
- 画面遷移図については、コードから推測した部分があるため、実際の動作と異なる可能性があります（リスク: 1）。

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csvのすべてのファイルパスが正しいか確認
- [ ] カテゴリ分類が適切か確認
- [ ] 画面説明が実際のUI機能と一致しているか確認
- [ ] 画面遷移図の遷移関係が実際の動作と一致しているか確認
- [ ] テスト用ファイル（No.59, 60）を一覧に含めるべきか検討
