# 画面遷移図

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における画面遷移を示します。

## 概要

Roslynプロジェクトは主にVisual Studio IDEのリファクタリング機能、オプション設定、ツールウィンドウなどのUI画面を提供しています。以下に主要な画面遷移を示します。

## 1. リファクタリングダイアログ遷移

```mermaid
flowchart TD
    subgraph Editor["エディタコンテキストメニュー"]
        CTX[コンテキストメニュー]
    end

    subgraph RefactoringDialogs["リファクタリングダイアログ"]
        CSD[シグネチャ変更ダイアログ]
        APD[パラメータ追加ダイアログ]
        GTD[型生成ダイアログ]
        ECD[クラス抽出ダイアログ]
        EID[インターフェース抽出ダイアログ]
        MTN[名前空間移動ダイアログ]
        PMD[メンバー引き上げダイアログ]
        PWD[メンバー引き上げ警告ダイアログ]
        PKD[メンバー選択ダイアログ]
        MSM[静的メンバー移動ダイアログ]
    end

    subgraph CommonControls["共通コントロール"]
        NTD[新規型作成先選択]
        MBS[メンバー選択コントロール]
    end

    CTX --> CSD
    CTX --> GTD
    CTX --> ECD
    CTX --> EID
    CTX --> MTN
    CTX --> PMD
    CTX --> PKD
    CTX --> MSM

    CSD -->|パラメータ追加| APD
    APD -->|完了| CSD

    PMD -->|警告発生時| PWD
    PWD -->|戻る| PMD
    PWD -->|完了| Editor

    ECD -.->|使用| NTD
    ECD -.->|使用| MBS
    EID -.->|使用| NTD
    EID -.->|使用| MBS
    PMD -.->|使用| MBS
    MSM -.->|使用| MBS
```

## 2. インラインリネーム遷移

```mermaid
flowchart TD
    subgraph Editor["エディタ"]
        ED[エディタビュー]
    end

    subgraph InlineRename["インラインリネームUI"]
        RF[リネームフライアウト]
        RIT[リネーム入力テキストボックス]
        SRC[スマートリネームコンボボックス]
        SRS[スマートリネームステータス]
    end

    ED -->|F2キー / リネーム実行| RF
    RF -.->|構成| RIT
    RF -.->|Copilot有効時| SRC
    SRC -.->|状態表示| SRS
    RF -->|Enter / Escape| ED
```

## 3. オプション設定遷移

```mermaid
flowchart TD
    subgraph VSOptions["Visual Studioオプション"]
        OPT[ツール > オプション]
    end

    subgraph CSharpOptions["C#オプション"]
        CSA[C#詳細設定]
        CSF[C#書式設定]
    end

    subgraph VBOptions["VBオプション"]
        VBA[VB詳細設定]
    end

    subgraph CodeStyleOptions["コードスタイルオプション"]
        GOP[グリッドオプションプレビュー]
        NSO[命名スタイルオプション]
        NSD[命名スタイルダイアログ]
        SSD[シンボル仕様ダイアログ]
        MSD[命名スタイル管理ダイアログ]
    end

    OPT --> CSA
    OPT --> CSF
    OPT --> VBA
    OPT --> GOP
    OPT --> NSO

    NSO -->|スタイル編集| NSD
    NSO -->|仕様編集| SSD
    NSO -->|スタイル管理| MSD
    NSD --> NSO
    SSD --> NSO
    MSD --> NSO
```

## 4. EditorConfig設定エディタ遷移

```mermaid
flowchart TD
    subgraph SolutionExplorer["ソリューションエクスプローラー"]
        ECF[.editorconfigファイル]
    end

    subgraph EditorConfigSettings["EditorConfig設定エディタ"]
        SEC[設定エディタコントロール]

        subgraph Tabs["タブ"]
            WST[空白設定タブ]
            CST[コードスタイルタブ]
            NST[命名スタイルタブ]
            ANT[アナライザータブ]
        end
    end

    subgraph WhitespaceViews["空白設定ビュー"]
        WSV[空白設定ビュー]
        WBV[空白ブール設定ビュー]
    end

    subgraph CodeStyleViews["コードスタイルビュー"]
        CSV[コードスタイル設定ビュー]
        CVL[コードスタイル値コントロール]
        CSV2[コードスタイル重大度コントロール]
    end

    subgraph NamingStyleViews["命名スタイルビュー"]
        NSV[命名スタイル設定ビュー]
        NTC[タイプコントロール]
        NSC[スタイルコントロール]
        NSE[重大度コントロール]
        NLC[場所コントロール]
    end

    subgraph AnalyzerViews["アナライザービュー"]
        ASV[アナライザー設定ビュー]
        SVC[重大度コントロール]
    end

    ECF -->|ダブルクリック| SEC
    SEC --> WST
    SEC --> CST
    SEC --> NST
    SEC --> ANT

    WST -.->|表示| WSV
    WSV -.->|使用| WBV

    CST -.->|表示| CSV
    CSV -.->|使用| CVL
    CSV -.->|使用| CSV2

    NST -.->|表示| NSV
    NSV -.->|使用| NTC
    NSV -.->|使用| NSC
    NSV -.->|使用| NSE
    NSV -.->|使用| NLC

    ANT -.->|表示| ASV
    ASV -.->|使用| SVC
```

## 5. ツールウィンドウ遷移

```mermaid
flowchart TD
    subgraph VSMenu["Visual Studioメニュー"]
        VM[表示メニュー]
    end

    subgraph ToolWindows["ツールウィンドウ"]
        DOV[ドキュメントアウトライン]
        VTR[値追跡ルート]
        VTT[値追跡ツリー]
        SER[スタックトレースエクスプローラールート]
        SEX[スタックトレースエクスプローラー]
    end

    subgraph DiagnosticTools["診断ツール"]
        SI[ステータスインジケーター]
        PBM[プロジェクションバッファマージン]
        TP[テレメトリパネル]
        WP[ワークスペースパネル]
    end

    VM --> DOV
    VM --> VTR
    VM --> SER

    VTR -.->|コンテンツ| VTT

    SER -.->|タブコンテンツ| SEX
```

## 6. エディタマージン遷移

```mermaid
flowchart TD
    subgraph EditorMargin["エディタマージン"]
        IM[継承マージングリフ]
    end

    subgraph ContextMenus["コンテキストメニュー"]
        ICM[継承マージンコンテキストメニュー]
    end

    subgraph Navigation["ナビゲーション先"]
        BC[基底クラス]
        DC[派生クラス]
        II[実装インターフェース]
        IM2[インターフェース実装]
    end

    IM -->|クリック| ICM
    ICM -->|基底型へ移動| BC
    ICM -->|派生型へ移動| DC
    ICM -->|インターフェースへ移動| II
    ICM -->|実装へ移動| IM2
```

## 7. クイック情報・プレビュー遷移

```mermaid
flowchart TD
    subgraph Editor["エディタ"]
        HV[ホバー]
        LB[電球アクション]
    end

    subgraph QuickInfo["クイック情報"]
        OFD[オンザフライドキュメント]
    end

    subgraph Preview["プレビュー"]
        PP[プレビューペイン]
    end

    subgraph ErrorDialog["エラーダイアログ"]
        DED[詳細エラー情報ダイアログ]
    end

    HV -->|Copilot有効時| OFD
    LB -->|コード修正プレビュー| PP

    PP -->|エラー発生時| DED
```

## 8. 未使用参照管理遷移

```mermaid
flowchart TD
    subgraph SolutionExplorer["ソリューションエクスプローラー"]
        PRJ[プロジェクト]
    end

    subgraph UnusedReferences["未使用参照"]
        URD[未使用参照削除ダイアログ]
    end

    PRJ -->|右クリック > 未使用参照の削除| URD
    URD -->|適用| PRJ
    URD -->|キャンセル| PRJ
```

## 凡例

- **実線矢印（-->）**: 画面遷移を示す
- **点線矢印（-.->）**: コンポーネントの使用・構成関係を示す
- **サブグラフ**: 関連する画面・コンポーネントのグループを示す
