---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **テスト用画面（59, 60）と機能の関連**：テストリソースのため実運用との関連が不明確
  2. **診断ツール画面（55-58）の機能分類**：診断専用機能のため関連機能の特定が曖昧
  3. **共通コントロール（12, 13）の機能帰属**：複数機能で使用されるため代表機能の選定根拠が限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml.cs`
- E-04: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml.cs`
- E-05: `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml.cs`
- E-06: `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml.cs`
- E-07: `src/VisualStudio/Core/Def/ExtractInterface/ExtractInterfaceDialog.xaml.cs`
- E-08: `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml.cs`
- E-09: `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml.cs`
- E-10: `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml.cs`
- E-11: `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml.cs`
- E-12: `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml.cs`
- E-13: `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml.cs`
- E-14: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml.cs`
- E-15: `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml.cs`
- E-16: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml.cs`
- E-17: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml.cs`
- E-18: `src/VisualStudio/Core/Def/UnusedReferences/Dialog/RemoveUnusedReferencesDialog.xaml.cs`
- E-19: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs`
- E-20: `src/VisualStudio/Core/Def/EditorConfigSettings/SettingsEditorControl.xaml.cs`
- E-21: `src/Features/Core/Portable/ChangeSignature/AbstractChangeSignatureService.cs`
- E-22: `src/Features/Core/Portable/ExtractInterface/AbstractExtractInterfaceService.cs`
- E-23: `src/Features/Core/Portable/ExtractClass/AbstractExtractClassRefactoringProvider.cs`
- E-24: `src/Features/Core/Portable/PullMemberUp/`（ディレクトリ）
- E-25: `src/Features/Core/Portable/MoveStaticMembers/`（ディレクトリ）
- E-26: `src/Features/Core/Portable/MoveToNamespace/`（ディレクトリ）
- E-27: `src/EditorFeatures/Core/InlineRename/`（ディレクトリ）
- E-28: `src/Features/Core/Portable/ValueTracking/`（ディレクトリ）
- E-29: `src/Features/Core/Portable/StackTraceExplorer/`（ディレクトリ）
- E-30: `src/Features/Core/Portable/UnusedReferences/`（ディレクトリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シグネチャ変更ダイアログ→シグネチャ変更（主機能） | E-03, E-21 | ○ |
| C-02 | シグネチャ変更ダイアログ→メンバー選択（補助機能） | E-03 | ○ |
| C-03 | パラメータ追加ダイアログ→シグネチャ変更（主機能） | E-04, E-03 | ○ |
| C-04 | 型生成ダイアログ→型生成（主機能） | E-05 | ○ |
| C-05 | クラス抽出ダイアログ→クラス抽出（主機能） | E-06, E-23 | ○ |
| C-06 | クラス抽出ダイアログ→メンバー選択（補助機能） | E-06 | ○ |
| C-07 | インターフェース抽出ダイアログ→インターフェース抽出（主機能） | E-07, E-22 | ○ |
| C-08 | インターフェース抽出ダイアログ→メンバー選択（補助機能） | E-07 | ○ |
| C-09 | 名前空間移動ダイアログ→名前空間の移動（主機能） | E-08, E-26 | ○ |
| C-10 | メンバー引き上げダイアログ→メンバーの引き上げ（主機能） | E-09, E-24 | ○ |
| C-11 | メンバー引き上げダイアログ→メンバー選択（補助機能） | E-09 | ○ |
| C-12 | メンバー引き上げ警告ダイアログ→メンバーの引き上げ（補助機能） | E-10 | ○ |
| C-13 | メンバー選択ダイアログ→メンバー選択（主機能） | E-11 | ○ |
| C-14 | 静的メンバー移動ダイアログ→静的メンバーの移動（主機能） | E-12, E-25 | ○ |
| C-15 | 静的メンバー選択コントロール→静的メンバーの移動（補助機能） | E-12 | ○ |
| C-16 | 新規型作成先選択コントロール→型生成（補助機能） | E-01 | ○ |
| C-17 | メンバー選択コントロール→メンバー選択（主機能） | E-01 | ○ |
| C-18 | ドキュメントアウトラインビュー→コード構造（主機能） | E-13 | ○ |
| C-19 | ドキュメントアウトラインビュー→ナビゲーション（補助機能） | E-13 | ○ |
| C-20 | 値追跡ルートビュー→値追跡（主機能） | E-14, E-28 | ○ |
| C-21 | 値追跡ツリービュー→値追跡（主機能） | E-15, E-28 | ○ |
| C-22 | スタックトレースエクスプローラールート→スタックトレース探索（主機能） | E-16, E-29 | ○ |
| C-23 | スタックトレースエクスプローラー→スタックトレース探索（主機能） | E-17, E-29 | ○ |
| C-24 | 未使用参照削除ダイアログ→未使用参照検出（主機能） | E-18, E-30 | ○ |
| C-25 | プレビューペイン→コードリファクタリング（補助機能） | E-01 | ○ |
| C-26 | リネームフライアウト→名前変更（主機能） | E-19, E-27 | ○ |
| C-27 | リネームフライアウト→Copilot連携（補助機能） | E-19 | ○ |
| C-28 | リネームユーザー入力テキストボックス→名前変更（補助機能） | E-19 | ○ |
| C-29 | インラインリネームカラー定義→名前変更（補助機能） | E-01 | ○ |
| C-30 | スマートリネームユーザー入力コンボボックス→名前変更・Copilot連携（主機能） | E-19 | ○ |
| C-31 | スマートリネームステータスコントロール→名前変更・Copilot連携（補助機能） | E-19 | ○ |
| C-32 | オンザフライドキュメントビュー→クイック情報・Copilot連携（主機能） | E-01 | ○ |
| C-33 | グリッドオプションプレビューコントロール→コードスタイル分析（主機能） | E-01 | ○ |
| C-34 | オプションプレビューコントロール→コードスタイル分析（主機能） | E-01 | ○ |
| C-35 | コードスタイル通知テキストブロック→コードスタイル分析（補助機能） | E-01 | ○ |
| C-36 | 命名スタイルオプションページコントロール→コードスタイル分析（主機能） | E-01 | ○ |
| C-37 | 命名スタイルダイアログ→コードスタイル分析（主機能） | E-01 | ○ |
| C-38 | シンボル仕様ダイアログ→コードスタイル分析（主機能） | E-01 | ○ |
| C-39 | 命名スタイル情報管理ダイアログ→コードスタイル分析（補助機能） | E-01 | ○ |
| C-40 | C#詳細オプションページコントロール→VS C#拡張（主機能） | E-01 | ○ |
| C-41 | C#書式設定オプションページコントロール→フォーマット（主機能） | E-01 | ○ |
| C-42 | VB詳細オプションページコントロール→VS VB拡張（主機能） | E-01 | ○ |
| C-43 | 設定エディタコントロール→コードスタイル分析（主機能） | E-20 | ○ |
| C-44 | 空白設定ビュー→コードスタイル分析（主機能） | E-20 | ○ |
| C-45 | 空白ブール設定ビュー→コードスタイル分析（補助機能） | E-01 | ○ |
| C-46 | コードスタイル設定ビュー→コードスタイル分析（主機能） | E-01 | ○ |
| C-47 | コードスタイル値コントロール→コードスタイル分析（補助機能） | E-01 | ○ |
| C-48 | コードスタイル重大度コントロール→コードスタイル分析（補助機能） | E-01 | ○ |
| C-49 | 命名スタイル設定ビュー→コードスタイル分析（主機能） | E-01 | ○ |
| C-50 | 命名スタイルタイプコントロール→コードスタイル分析（補助機能） | E-01 | ○ |
| C-51 | 命名スタイルスタイルコントロール→コードスタイル分析（補助機能） | E-01 | ○ |
| C-52 | 命名スタイル重大度コントロール→コードスタイル分析（補助機能） | E-01 | ○ |
| C-53 | 命名スタイル場所コントロール→コードスタイル分析（補助機能） | E-01 | ○ |
| C-54 | アナライザー設定ビュー→診断エンジン・Roslynアナライザー（主機能・補助機能） | E-01, E-20 | ○ |
| C-55 | 重大度コントロール→診断エンジン（補助機能） | E-01 | ○ |
| C-56 | 列挙プロパティビュー→コードスタイル分析（補助機能） | E-01 | ○ |
| C-57 | タブコントロールスタイル→コードスタイル分析（補助機能） | E-01 | ○ |
| C-58 | 詳細エラー情報ダイアログ→VS コア（主機能） | E-01 | ○ |
| C-59 | 継承マージンコンテキストメニュー→継承マージン（主機能） | E-01 | ○ |
| C-60 | VSテーマ辞書→VS コア（補助機能） | E-01 | ○ |
| C-61 | ステータスインジケーター→IDEベンチマーク（主機能） | E-01 | ○ |
| C-62 | プロジェクションバッファマージン→VS コア（主機能） | E-01 | ○ |
| C-63 | テレメトリパネル→VS コア（主機能） | E-01 | ○ |
| C-64 | ワークスペースパネル→ワークスペース管理（主機能） | E-01 | ○ |
| C-65 | App.xaml（テスト用）→MSBuildワークスペース（補助機能） | **根拠不足** | △ |
| C-66 | MainWindow.xaml（テスト用）→MSBuildワークスペース（補助機能） | **根拠不足** | △ |
| C-67 | 診断ツール画面（55-58）の機能分類 | **推定による分類** | △ |

## 4) 不足情報（Unknown / Missing）
- **テスト用画面（59, 60）の機能関連**：テストリソースファイルのため、実際の機能との関連が間接的
  - 候補：MSBuildテスト機能 / テストフレームワーク / 該当なし
- **診断ツール画面の機能帰属**：診断専用のUI部品であり、一般的なIDE機能とは異なるカテゴリ
  - 候補：VS コア / 診断エンジン / 専用の診断機能カテゴリ
- **共通コントロールの代表機能**：複数機能で使用されるため、単一の機能への帰属が困難
  - 候補：使用頻度最多の機能 / コントロール専用カテゴリ / 全関連機能の列挙

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - リファクタリング系ダイアログ（1-15）：名前空間とコードから明確に関連付け可能
- **0: 低リスク** - エディタ機能系（21-26）：InlineRename関連コードから明確
- **0: 低リスク** - EditorConfig設定系（37-51）：SettingsEditorControlの構造から明確
- **1: 中リスク** - オプション系（27-36）：機能一覧の「コードスタイル分析」との対応が広範囲
- **1: 中リスク** - 診断ツール系（55-58）：独自の診断用途のため一般機能との関連が曖昧
- **2: 高リスク** - テスト用画面（59-60）：テストリソースのため実運用との関連が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] リファクタリング系ダイアログ（No.1-15）の主機能・補助機能の分類が適切か
- [ ] インラインリネーム系（No.21-25）のCopilot連携の関連種別が適切か
- [ ] EditorConfig設定系（No.37-51）のコードスタイル分析への集約が妥当か
- [ ] 診断ツール系（No.55-58）の機能割り当てが意図通りか
- [ ] テスト用画面（No.59-60）をマッピングに含めることの是非
- [ ] 共通コントロール（No.12-13）の機能帰属の妥当性
