# 画面設計書 1-シグネチャ変更ダイアログ

## 概要

本ドキュメントは、Visual Studio IDE上でメソッドシグネチャを変更するためのダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

シグネチャ変更ダイアログは、メソッド、コンストラクタ、インデクサーなどのシグネチャを安全に変更するためのリファクタリング機能を提供する画面である。

**業務上の目的・背景**：ソフトウェア開発において、メソッドのパラメータ構成を変更する必要は頻繁に発生する。手動でパラメータを変更すると、呼び出し元の更新漏れやコンパイルエラーの原因となる。本ダイアログは、パラメータの追加・削除・並べ替えを一括で行い、すべての呼び出し元を自動的に更新することで、リファクタリングの安全性と効率性を確保する。

**画面へのアクセス方法**：エディタ内でメソッド・コンストラクタ・インデクサーのシグネチャ部分にカーソルを置き、コンテキストメニューから「シグネチャの変更」を選択、またはクイックアクション（電球アイコン）から実行する。

**主要な操作・処理内容**：
1. パラメータ一覧の表示と選択
2. パラメータの上下移動（Alt+Up/Alt+Down）
3. パラメータの削除（Deleteキーまたは「Remove」ボタン）
4. 削除したパラメータの復元（「Restore」ボタン）
5. 新規パラメータの追加（「Add」ボタン → パラメータ追加ダイアログ）
6. 変更後のシグネチャプレビュー表示
7. 参照変更のプレビューオプション
8. OKボタンで変更を確定、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：エディタコンテキストメニュー、クイックアクション
- 遷移先：パラメータ追加ダイアログ（Addボタン押下時）
- 戻り先：エディタ（OK/Cancel時）

**権限による表示制御**：特になし。エディタ上で対象シンボルにアクセスできれば利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | シグネチャ変更 | 主機能 | メソッドパラメータの追加・削除・並び替えを行う主処理 |
| 137 | メンバー選択 | 補助機能 | パラメータ一覧の表示と選択操作 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| パラメータ一覧 | 入力 | List<ParameterViewModel> | Yes | 対象メソッドの現在のパラメータ情報 |
| 選択インデックス | 入出力 | int? | No | 現在選択中のパラメータインデックス |
| プレビュー変更フラグ | 出力 | bool | No | 参照変更をプレビュー表示するか |
| 変更後パラメータ構成 | 出力 | ParameterConfiguration | Yes | 確定時の新しいパラメータ構成 |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| Index | ParameterViewModel.InitialIndex | 整数 | パラメータの元のインデックス番号 |
| Modifier | ParameterViewModel.Modifier | テキスト | パラメータ修飾子（ref, out, params等） |
| Type | ParameterViewModel.Type | テキスト | パラメータの型名 |
| Parameter | ParameterViewModel.ParameterName | テキスト | パラメータ名 |
| Default | ParameterViewModel.DefaultValue | テキスト | デフォルト値 |
| Callsite | ParameterViewModel.CallSite | テキスト | 呼び出し元での値 |
| SignaturePreview | SignatureDisplay | TextBlock | 変更後のシグネチャプレビュー |

## イベント仕様

### 1-パラメータ選択変更

DataGrid上でパラメータ行を選択すると、SelectedIndexプロパティが更新され、CanMoveUp/CanMoveDown/CanRemove/CanRestoreの状態が再評価される。

### 2-上へ移動（MoveUp）

選択中のパラメータを一つ上の位置に移動する。パラメータは同じグループ内（デフォルト値なし/デフォルト値あり）でのみ移動可能。

### 3-下へ移動（MoveDown）

選択中のパラメータを一つ下の位置に移動する。パラメータは同じグループ内でのみ移動可能。

### 4-削除（Remove）

選択中のパラメータを削除マークする。既存パラメータは論理削除（取り消し線表示）、追加パラメータは物理削除される。

### 5-復元（Restore）

削除マークされた既存パラメータを復元する。

### 6-追加（Add）

パラメータ追加ダイアログを表示し、新規パラメータを追加する。追加されたパラメータはIsRequiredプロパティに応じて適切なグループに配置される。

### 7-OK確定

シグネチャが変更されているか検証し、変更がある場合はDialogResult=trueで閉じる。変更がない場合は通知を表示。

### 8-キャンセル

DialogResult=falseでダイアログを閉じ、変更を破棄する。

## データベース更新仕様

該当なし（データベースアクセスなし、ソースコードのリファクタリング操作）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| 情報 | INFO_NO_CHANGE | シグネチャを変更する必要があります | シグネチャ未変更でOK押下時 |
| 警告 | WARN_TYPE_NOT_BIND | 警告：型がバインドされません | 追加パラメータの型が解決できない場合 |
| 警告 | WARN_DUPLICATE_NAME | 警告：パラメータ名が重複しています | 同名パラメータが存在する場合 |

## 例外処理

| 状態 | 対応 |
|------|------|
| 対象シンボルが見つからない | ダイアログを表示せずエラー通知 |
| ドキュメントが読み取り専用 | ダイアログを表示せずエラー通知 |

## 備考

- ヘルプトピック: vs.csharp.refactoring.reorder
- thisパラメータ（拡張メソッド）は編集不可（グレーアウト表示）
- paramsパラメータは削除のみ可能（移動不可）
- ハイコントラストモードに対応したカラースキーム

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パラメータ情報の構造とViewModel層のデータバインディングを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ParameterConfiguration.cs | `src/Features/Core/Portable/ChangeSignature/ParameterConfiguration.cs` | パラメータ構成全体を保持するデータ構造 |
| 1-2 | Parameter.cs | `src/Features/Core/Portable/ChangeSignature/Parameter.cs` | 個別パラメータの基底クラス |
| 1-3 | ExistingParameter.cs | `src/Features/Core/Portable/ChangeSignature/ExistingParameter.cs` | 既存パラメータの表現 |
| 1-4 | AddedParameter.cs | `src/Features/Core/Portable/ChangeSignature/AddedParameter.cs` | 追加パラメータの表現 |

**読解のコツ**: ParameterConfigurationがThisParameter、ParametersWithoutDefaultValues、RemainingEditableParameters、ParamsParameterの4グループでパラメータを管理していることを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるダイアログの表示とViewModelの初期化を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ChangeSignatureDialog.xaml.cs | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml.cs` | ダイアログのコードビハインド、コンストラクタでViewModelとバインド |
| 2-2 | ChangeSignatureDialogViewModel.cs | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialogViewModel.cs` | ViewModel、パラメータ操作のビジネスロジック |

**主要処理フロー**:
1. **行47-73**: コンストラクタでパラメータ構成を受け取り、ParameterViewModelリストを構築
2. **行383-403**: AllParametersプロパティで全パラメータを統合して返却
3. **行225-243**: Remove()でパラメータを削除（論理/物理）
4. **行245-250**: Restore()でパラメータを復元
5. **行252-265**: AddParameter()で新規パラメータを追加

#### Step 3: UI定義を理解する

XAMLでのUI構成とデータバインディングを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ChangeSignatureDialog.xaml | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml` | DataGrid列定義、ボタン配置、コマンドバインディング |

**主要処理フロー**:
- **行90-308**: DataGridでパラメータ一覧を表示
- **行334-389**: 上下移動、追加、削除、復元ボタン群
- **行392-398**: プレビュー変更チェックボックス
- **行400-422**: OK/Cancelボタン

#### Step 4: パラメータ追加ダイアログとの連携

パラメータ追加時のサブダイアログとの連携を理解。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AddParameterDialog.xaml | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml` | 追加パラメータのUI定義 |
| 4-2 | AddParameterDialogViewModel.cs | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialogViewModel.cs` | 追加パラメータのバリデーションロジック |

### プログラム呼び出し階層図

```
ChangeSignatureDialog (UI)
    │
    ├─ ChangeSignatureDialogViewModel
    │      ├─ AllParameters (パラメータ一覧管理)
    │      ├─ MoveUp/MoveDown (並べ替え)
    │      ├─ Remove/Restore (削除・復元)
    │      ├─ AddParameter (追加)
    │      └─ GetParameterConfiguration (結果取得)
    │
    ├─ AddParameterDialog (サブダイアログ)
    │      └─ AddParameterDialogViewModel
    │             └─ TrySubmit (入力検証)
    │
    └─ ParameterViewModel
           ├─ ExistingParameterViewModel (既存パラメータ)
           └─ AddedParameterViewModel (追加パラメータ)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ParameterConfiguration ──▶ ChangeSignatureDialogViewModel ──▶ 変更後ParameterConfiguration
     │                           │
     └─ 既存パラメータ情報        ├─ パラメータ移動/削除/追加
                                 │
AddedParameter ◀───────────── AddParameterDialog
     │                           │
     └─ 新規パラメータ情報        └─ 型・名前・呼び出し元値の検証
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ChangeSignatureDialog.xaml | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml` | XAML | ダイアログUI定義 |
| ChangeSignatureDialog.xaml.cs | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml.cs` | ソース | ダイアログのコードビハインド |
| ChangeSignatureDialogViewModel.cs | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialogViewModel.cs` | ソース | ダイアログのViewModel |
| ChangeSignatureDialogViewModel.ParameterViewModel.cs | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialogViewModel.ParameterViewModel.cs` | ソース | パラメータ行のViewModel |
| AddParameterDialog.xaml | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml` | XAML | パラメータ追加ダイアログUI |
| AddParameterDialog.xaml.cs | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml.cs` | ソース | パラメータ追加のコードビハインド |
| AddParameterDialogViewModel.cs | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialogViewModel.cs` | ソース | パラメータ追加のViewModel |
| ChangeSignatureLogger.cs | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureLogger.cs` | ソース | テレメトリログ記録 |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
