# 画面設計書 10-静的メンバー移動ダイアログ

## 概要

本ドキュメントは、静的メンバーを別の型に移動するためのダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

静的メンバー移動ダイアログは、静的メソッド、プロパティ、フィールドなどを別のクラスまたは新規クラスに移動するリファクタリング機能を提供する画面である。

**業務上の目的・背景**：静的メンバーはクラスの責務と無関係に増加しがちで、クラスの肥大化やユーティリティクラスの散在を招く。本ダイアログは、静的メンバーを適切な型に移動し、参照を自動更新することで、コードの整理と責務の明確化を支援する。

**画面へのアクセス方法**：エディタ内で静的メンバー定義にカーソルを置き、コンテキストメニューまたはクイックアクションから「Move static members to another type...」を選択する。

**主要な操作・処理内容**：
1. 移動先の型名を入力または選択
2. 既存の型リストから選択（履歴付き）
3. 新しい型を作成する場合は型名を入力
4. 移動するメンバーの選択（StaticMemberSelectionコントロール）
5. 入力検証とエラー/警告メッセージの表示
6. OKボタンで移動実行、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：エディタコンテキストメニュー、クイックアクション
- 遷移先：なし
- 戻り先：エディタ（OK/Cancel時）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 67 | 静的メンバー移動 | 主機能 | 静的メンバーを別の型に移動する設定 |
| 137 | メンバー選択 | 補助機能 | 移動対象メンバーの選択操作 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| SearchText | 入出力 | string | No | 移動先型名の検索/入力テキスト |
| SelectedIndex | 入出力 | int | No | 選択された候補のインデックス |
| AvailableTypes | 入力 | List<TypeNameItem> | Yes | 利用可能な型候補 |
| TypeName_NamespaceOnly | 出力 | string | No | 選択/入力された型の名前空間部分 |
| TypeName_NameOnly | 出力 | string | No | 選択/入力された型の名前部分 |
| MemberSelectionViewModel | 入出力 | StaticMemberSelectionViewModel | Yes | 移動するメンバー選択 |
| CanSubmit | 出力 | bool | Yes | 送信可能か |
| Message | 出力 | string | No | エラー/警告メッセージ |
| Icon | 出力 | ImageMoniker | No | メッセージアイコン |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| 移動先型名入力 | SearchText | 編集可能ComboBox | 型名の入力/選択 |
| 型候補リスト | AvailableTypes | ComboBoxドロップダウン | 既存型と履歴 |
| 履歴アイコン | IsFromHistory | CrispImage | 履歴からの候補を示すアイコン |
| 完全修飾型名 | FullyQualifiedTypeName | TextBlock | 型のフル名 |
| 宣言ファイル名 | DeclarationFileName | TextBlock | 型が宣言されているファイル |
| メッセージアイコン | Icon | CrispImage | エラー/警告アイコン |
| メッセージ | Message | LiveTextBlock | バリデーションメッセージ |
| 名前空間表示 | TypeName_NamespaceOnly | LiveTextBlock | 解析された名前空間 |
| 型名表示 | TypeName_NameOnly | LiveTextBlock | 解析された型名 |
| メンバー一覧 | MemberSelectionViewModel | StaticMemberSelectionコントロール | 移動候補メンバー |

## イベント仕様

### 1-移動先型名入力変更

型名をテキスト入力または候補から選択するとSearchTextプロパティが更新され、バリデーションが実行される。

### 2-バリデーション

入力された型名に対して以下を検証：
- 有効な型名形式か
- 既存の型か新規作成か
- 静的メンバーを受け入れ可能な型か

結果に応じてMessage、Icon、CanSubmitプロパティが更新される。

### 3-候補選択

ComboBoxのドロップダウンから候補を選択。履歴からの候補にはHistoryアイコンが表示される。型名とファイル名が表示される。

### 4-メンバー選択変更

StaticMemberSelectionコントロール内でメンバーを選択/解除。

### 5-OK確定

CanSubmit=trueの場合のみDialogResult=trueで閉じる。

### 6-キャンセル

DialogResult=falseでダイアログを閉じる。

## データベース更新仕様

該当なし（データベースアクセスなし、ソースコードリファクタリング操作）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| エラー | ERR_INVALID_TYPE | 無効な型名です | 不正な識別子形式時 |
| 情報 | INFO_CREATE_NEW | 新しい型が作成されます | 存在しない型入力時 |
| 情報 | INFO_EXISTING_TYPE | 既存の型に移動します | 既存の型選択時 |
| 警告 | WARN_NO_MEMBERS | メンバーを選択してください | メンバー未選択時 |

## 例外処理

| 状態 | 対応 |
|------|------|
| 型名が無効 | OKボタンを無効化、エラーメッセージ表示 |
| 参照更新不可 | ダイアログ表示せずエラー通知 |

## 備考

- ダイアログサイズ: 500x498（最小210x298）
- リサイズ可能（CanResize）
- 編集可能ComboBox（IsEditable=True, IsReadOnly=False）
- ドロップダウン最大高さ120px
- StaticMemberSelectionコントロールを使用（静的メンバー専用）
- 名前空間と型名が分離して表示される（TypeName_NamespaceOnly + TypeName_NameOnly）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MoveStaticMembersDialogViewModel.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialogViewModel.cs` | ダイアログ全体のViewModel |
| 1-2 | TypeNameItem.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/TypeNameItem.cs` | 型候補の表現 |
| 1-3 | StaticMemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelectionViewModel.cs` | メンバー選択のViewModel |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MoveStaticMembersDialog.xaml.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml.cs` | ダイアログのコードビハインド |

**主要処理フロー**:
1. **行27-39**: コンストラクタでViewModelをバインド、StaticMemberSelectionコントロール初期化
2. **行41-42**: Cancel_ClickでDialogResult=false
3. **行46-49**: OK_ClickでCanSubmit確認後にDialogResult設定

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MoveStaticMembersDialog.xaml | `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml` | ダイアログUI定義 |
| 3-2 | StaticMemberSelection.xaml | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml` | メンバー選択コントロール |

**主要処理フロー**:
- **行34-136**: StackPanel（型入力、メッセージ、名前空間/型名表示）
- **行40-91**: DestinationBox（編集可能ComboBox）
- **行94-135**: メッセージとプレビュー表示GroupBox
- **行138-147**: MemberSelectionGroupBox
- **行148-171**: OK/Cancelボタン

### プログラム呼び出し階層図

```
MoveStaticMembersDialog (UI)
    │
    ├─ MoveStaticMembersDialogViewModel
    │      ├─ SearchText (入力/選択テキスト)
    │      ├─ AvailableTypes (型候補)
    │      │      └─ TypeNameItem
    │      │             ├─ FullyQualifiedTypeName
    │      │             ├─ DeclarationFileName
    │      │             └─ IsFromHistory
    │      │
    │      ├─ TypeName_NamespaceOnly / TypeName_NameOnly
    │      ├─ Message / Icon
    │      ├─ CanSubmit
    │      └─ MemberSelectionViewModel
    │
    └─ StaticMemberSelection (専用コントロール)
           └─ StaticMemberSelectionViewModel
```

### データフロー図

```
[入力]                    [処理]                         [出力]

静的メンバー情報 ──────▶ MoveStaticMembersDialog ─────▶ 移動先型へのメンバー移動
     │                       │                           │
     ├─ 既存型リスト         │                           ├─ 移動されたメンバー
     ├─ 移動先型名           │                           └─ すべての参照を更新
     └─ メンバー選択         │
                            ▼
                    新規型作成 or 既存型へ追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MoveStaticMembersDialog.xaml | `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml` | XAML | ダイアログUI定義 |
| MoveStaticMembersDialog.xaml.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml.cs` | ソース | コードビハインド |
| MoveStaticMembersDialogViewModel.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialogViewModel.cs` | ソース | ViewModel |
| TypeNameItem.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/TypeNameItem.cs` | ソース | 型候補データ |
| StaticMemberSelection.xaml | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml` | XAML | メンバー選択コントロール |
| StaticMemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelectionViewModel.cs` | ソース | メンバー選択ViewModel |
| KnownMonikers.History | Microsoft.VisualStudio.ImageCatalog | リソース | 履歴アイコン |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
