# 画面設計書 11-静的メンバー選択コントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「静的メンバー選択コントロール」の画面設計を記述するものである。

### 本画面の処理概要

静的メンバー選択コントロールは、静的メンバー移動ダイアログ（MoveStaticMembersDialog）の子コントロールとして機能し、移動対象となる静的メンバーをユーザーが選択するためのUIを提供する。

**業務上の目的・背景**：
コードリファクタリングにおいて、クラス内の静的メンバー（メソッド、フィールド、プロパティなど）を別の型に移動する際、どのメンバーを移動するかを選択する必要がある。本コントロールは、移動可能な静的メンバーの一覧を表示し、チェックボックスによる選択機能を提供することで、開発者が効率的にリファクタリング対象を選定できるようにする。また、依存関係のあるメンバーを自動選択する機能により、不完全なリファクタリングを防止する。

**画面へのアクセス方法**：
1. Visual Studioエディタ内で静的メンバーを含むクラスを開く
2. コンテキストメニューから「Move static members」を選択
3. 静的メンバー移動ダイアログが表示され、本コントロールが埋め込まれた状態で表示される

**主要な操作・処理内容**：
1. 静的メンバー一覧の表示：移動可能な静的メンバーをアイコン付きリストで表示
2. 個別メンバーの選択/選択解除：チェックボックスで各メンバーの選択状態を切り替え
3. 全選択：「Select All」ボタンで全メンバーを選択状態にする
4. 全選択解除：「Deselect All」ボタンで全メンバーの選択を解除する
5. 依存関係選択：「Select Dependents」ボタンで選択中のメンバーが依存するメンバーを自動選択

**画面遷移**：
- 遷移元：静的メンバー移動ダイアログ（MoveStaticMembersDialog）からコントロールとして埋め込み
- 遷移先：なし（親ダイアログの一部として機能）

**権限による表示制御**：
特別な権限制御はなし。コントロールはメンバーの可視性（public/private等）に基づいて全ての移動可能な静的メンバーを表示する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | 静的メンバーの移動 | 補助機能 | 静的メンバー移動ダイアログのメンバー選択部品 |

## 画面種別

一覧選択（リスト形式のメンバー選択UI）

## URL/ルーティング

N/A（WPF UserControlとして実装、Visual Studio拡張機能の一部）

## 入出力項目

### 入力（バインディングプロパティ）

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| Members | ImmutableArray&lt;SymbolViewModel&lt;ISymbol&gt;&gt; | Yes | 表示する静的メンバーのコレクション |

### 出力（バインディングプロパティ）

| 項目名 | 型 | 説明 |
|--------|------|------|
| CheckedMembers | ImmutableArray&lt;SymbolViewModel&lt;ISymbol&gt;&gt; | 選択された静的メンバーのコレクション |

## 表示項目

### メンバー一覧（ListBox: MemberSelectionList）

| 項目名 | バインディング | 説明 |
|--------|---------------|------|
| チェックボックス | IsChecked (TwoWay) | メンバーの選択状態 |
| メンバーアイコン | Glyph | メンバー種別を示すアイコン（16x16） |
| メンバー名 | SymbolName | 静的メンバーの名前 |

### ボタン群

| ボタン名 | ラベル | 説明 |
|----------|--------|------|
| SelectAllButton | Select All | 全メンバーを選択 |
| DeselectAllButton | Deselect All | 全メンバーの選択を解除 |
| SelectDependentsButton | Select Dependents | 依存メンバーを自動選択 |

## イベント仕様

### 1-チェックボックス変更

メンバーのチェックボックス状態変更時、`IsChecked`プロパティがTwoWayバインディングにより自動更新される。

### 2-Select All ボタン押下

1. `SelectAllButton_Click`イベントハンドラが実行される
2. `ViewModel.SelectAll()`が呼び出される
3. 全メンバーの`IsChecked`プロパティが`true`に設定される

### 3-Deselect All ボタン押下

1. `DeselectAllButton_Click`イベントハンドラが実行される
2. `ViewModel.DeselectAll()`が呼び出される
3. 全メンバーの`IsChecked`プロパティが`false`に設定される

### 4-Select Dependents ボタン押下

1. `SelectDependentsButton_Click`イベントハンドラが実行される
2. `ViewModel.SelectDependents()`が呼び出される
3. UIスレッドオペレーションエグゼキュータでプログレスダイアログを表示
4. 選択中のメンバーに対して依存関係を計算
5. 依存するメンバーを再帰的に検索し、全て選択状態にする

## データベース更新仕様

N/A（本コントロールはデータベースとの直接的なやり取りは行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| - | プログレス | "Calculating dependents" | Select Dependents実行中 |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| 依存関係計算のキャンセル | ユーザーがキャンセルした場合、依存関係選択処理を中断し、現在の選択状態を維持 |
| 循環依存 | HashSetを使用して訪問済みメンバーを追跡し、無限ループを防止 |

## 備考

- 本コントロールはMoveStaticMembersDialogの一部として使用される
- ListBoxのSelectionModeはMultipleに設定されており、複数選択が可能
- BooleanReverseConverterがリソースとして登録されているが、現在のUI定義では未使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メンバー情報を保持するViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StaticMemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelectionViewModel.cs` | メンバー一覧（Members）、選択状態管理、依存関係マップの構造を理解 |
| 1-2 | SymbolViewModel.cs | `src/VisualStudio/Core/Def/Implementation/Utilities/SymbolViewModel.cs` | 個々のシンボル（メンバー）の表示情報とIsChecked状態の管理 |

**読解のコツ**: `ImmutableDictionary<ISymbol, Task<ImmutableArray<ISymbol>>>`は依存関係の非同期計算結果をキャッシュするためのマップ。

#### Step 2: エントリーポイントを理解する

XAML定義とコードビハインドでUIの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StaticMemberSelection.xaml | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml` | ListBoxとボタン群のレイアウト、データバインディング定義 |
| 2-2 | StaticMemberSelection.xaml.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml.cs` | イベントハンドラとViewModelの接続 |

**主要処理フロー**:
1. **行23-28**: コンストラクタでViewModelを受け取り、DataContextに設定
2. **行30-31**: SelectDependentsButton_ClickでViewModelのSelectDependentsを呼び出し
3. **行33-37**: SelectAll/DeselectAllボタンのイベント処理

#### Step 3: 依存関係選択ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StaticMemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelectionViewModel.cs` | SelectDependentsメソッド（行47-73）の実装 |

**主要処理フロー**:
- **行47-51**: 選択中のメンバーを取得
- **行52-63**: UIスレッドオペレーションで依存関係計算を実行
- **行65-72**: 計算完了後、依存メンバーを再帰的に選択
- **行83-107**: FindDependentsメソッドでBFS（幅優先探索）による依存関係の探索

### プログラム呼び出し階層図

```
StaticMemberSelection (UserControl)
    │
    ├─ StaticMemberSelectionViewModel
    │      ├─ SelectAll() → 全メンバーのIsChecked=true
    │      ├─ DeselectAll() → 全メンバーのIsChecked=false
    │      └─ SelectDependents()
    │             ├─ UIThreadOperationExecutor.Execute()
    │             │      └─ 依存関係計算タスクの待機
    │             └─ FindDependents(ISymbol)
    │                    └─ BFSで依存メンバーを探索
    │
    └─ SymbolViewModel<ISymbol>
           ├─ IsChecked (選択状態)
           ├─ SymbolName (表示名)
           └─ Glyph (アイコン)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

静的メンバー一覧 ───▶ StaticMemberSelectionViewModel ───▶ CheckedMembers
(ISymbol[])            │                                  (選択済みメンバー)
                       ├─ 依存関係マップ参照
                       │   (symbolToDependentsMap)
                       │
依存関係計算結果 ─────▶├─ FindDependents()
(Task<ISymbol[]>)      │   (BFS探索)
                       │
ユーザー操作 ─────────▶└─ IsChecked更新
(チェック/ボタン)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StaticMemberSelection.xaml | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml` | XAML | UI定義 |
| StaticMemberSelection.xaml.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelection.xaml.cs` | ソース | コードビハインド |
| StaticMemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/MoveStaticMembers/StaticMemberSelectionViewModel.cs` | ソース | ViewModel実装 |
| MoveStaticMembersDialog.xaml | `src/VisualStudio/Core/Def/MoveStaticMembers/MoveStaticMembersDialog.xaml` | XAML | 親ダイアログ定義 |
| SymbolViewModel.cs | `src/VisualStudio/Core/Def/Implementation/Utilities/SymbolViewModel.cs` | ソース | シンボル表示ViewModel |
| BooleanReverseConverter.cs | `src/VisualStudio/Core/Def/Implementation/Utilities/BooleanReverseConverter.cs` | ソース | 値コンバーター |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
