# 画面設計書 13-メンバー選択コントロール

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「メンバー選択コントロール」の画面設計を記述するものである。

### 本画面の処理概要

メンバー選択コントロール（MemberSelection）は、複数のリファクタリングダイアログで共通利用される汎用的なメンバー選択UIコンポーネントである。クラスのメンバー（メソッド、プロパティ、フィールドなど）を一覧表示し、チェックボックスで選択できる機能を提供する。

**業務上の目的・背景**：
クラス抽出、インターフェース抽出、メンバー引き上げなど、複数のリファクタリング操作で対象メンバーを選択する必要がある。本コントロールは、これらの操作で共通して使用される選択UIを一元化することで、UI/UXの一貫性を保ちつつ、コードの重複を排除する。また、「Make Abstract」オプションにより、引き上げ時にメンバーを抽象化するかどうかの選択も可能にする。

**画面へのアクセス方法**：
本コントロールは単体では使用されず、以下のダイアログに埋め込まれて使用される：
1. クラス抽出ダイアログ（ExtractClassDialog）
2. インターフェース抽出ダイアログ（ExtractInterfaceDialog）
3. メンバー引き上げダイアログ（PullMemberUpDialog）
4. 静的メンバー移動ダイアログ（MoveStaticMembersDialog）

**主要な操作・処理内容**：
1. メンバー一覧の表示：DataGridでメンバーをアイコン・名前付きで表示
2. 個別メンバーの選択/選択解除：チェックボックスで各メンバーの選択状態を切り替え
3. Make Abstract設定：メンバーを抽象として引き上げるかどうかを設定（インターフェースへの引き上げ時は非表示）
4. 全選択/全選択解除：ボタンで一括操作
5. 依存関係選択：選択中のメンバーが依存するメンバーを自動選択
6. パブリックメンバー選択：publicメンバーのみを一括選択

**画面遷移**：
- 遷移元：各種リファクタリングダイアログからコントロールとして埋め込み
- 遷移先：なし（親ダイアログの一部として機能）

**権限による表示制御**：
- `ShowCheckDependentsButton`：依存関係選択ボタンの表示/非表示
- `ShowPublicButton`：パブリック選択ボタンの表示/非表示
- `ShowMakeAbstract`：Make Abstract列の表示/非表示（移動先がインターフェースの場合は非表示）
- フィールドはインターフェースへの移動時に選択不可（IsCheckable=false）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 137 | メンバー選択 | 主機能 | 複数ダイアログで再利用されるメンバー選択の共通UI |

## 画面種別

一覧選択（DataGrid形式のメンバー選択UI）

## URL/ルーティング

N/A（WPF UserControlとして実装、Visual Studio拡張機能の一部）

## 入出力項目

### 入力（コンストラクタ引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| viewModel | MemberSelectionViewModel | Yes | メンバー一覧と状態を管理するViewModel |

### ViewModel構成プロパティ

| プロパティ名 | 型 | 説明 |
|-------------|------|------|
| Members | ImmutableArray&lt;MemberSymbolViewModel&gt; | 表示するメンバーのコレクション |
| CheckedMembers | ImmutableArray&lt;MemberSymbolViewModel&gt; | 選択されたメンバーのコレクション |
| ShowCheckDependentsButton | bool | 依存関係選択ボタンの表示状態 |
| ShowPublicButton | bool | パブリック選択ボタンの表示状態 |
| ShowMakeAbstract | bool | Make Abstract列の表示状態 |

## 表示項目

### メンバー一覧（DataGrid: MemberSelectionGrid）

| 列名 | コントロール | バインディング | 説明 |
|------|-------------|---------------|------|
| 選択チェックボックス | CheckBox | IsChecked (TwoWay) | メンバーの選択状態 |
| メンバー情報 | StackPanel | SymbolName, Glyph | アイコンとメンバー名 |
| Make Abstract | CheckBox | MakeAbstract (TwoWay) | 抽象化オプション |

### ボタン群

| ボタン名 | ラベル | 表示条件 | 説明 |
|----------|--------|----------|------|
| SelectAllButton | Select All | 常時 | 全メンバーを選択 |
| DeselectAllButton | Deselect All | 常時 | 全メンバーの選択を解除 |
| SelecDependentsButton | Select Dependents | ShowCheckDependentsButton | 依存メンバーを自動選択 |
| SelectPublicButton | Select Public | ShowPublicButton | publicメンバーを選択 |

## イベント仕様

### 1-チェックボックス変更

1. メンバーのチェックボックス状態変更
2. TwoWayバインディングによりMemberSymbolViewModel.IsCheckedが更新
3. ViewModelのMemberPropertyChangedHandlerが呼び出される
4. CheckedMembersプロパティ変更が通知される

### 2-Select All ボタン押下

1. `SelectAllButton_Click`イベントハンドラが実行される
2. `ViewModel.SelectAll()`が呼び出される
3. IsCheckable=trueの全メンバーのIsCheckedがtrueに設定される

### 3-Deselect All ボタン押下

1. `DeselectAllButton_Click`イベントハンドラが実行される
2. `ViewModel.DeselectAll()`が呼び出される
3. 全メンバーのIsCheckedがfalseに設定される

### 4-Select Dependents ボタン押下

1. `SelectDependentsButton_Click`イベントハンドラが実行される
2. `ViewModel.SelectDependents()`が呼び出される
3. UIスレッドオペレーションエグゼキュータでプログレスダイアログを表示
4. 選択中のメンバーに対して依存関係を計算
5. 依存するメンバーを再帰的に検索し、全て選択状態にする

### 5-Select Public ボタン押下

1. `SelectPublic_Click`イベントハンドラが実行される
2. `ViewModel.SelectPublic()`が呼び出される
3. Accessibility.Publicのメンバーが全て選択される

### 6-Make Abstract列表示更新

1. ViewModelのShowMakeAbstractプロパティが変更される
2. ViewModel_PropertyChangedハンドラが呼び出される
3. UpdateAbstractColumnVisibilityメソッドでAbstractColumnの表示状態が更新される

## データベース更新仕様

N/A（本コントロールはデータベースとの直接的なやり取りは行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| - | プログレス | "Calculating dependents" | Select Dependents実行中 |
| - | ツールチップ | "Interface cannot have field" | フィールドがインターフェースに移動できない場合 |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| 依存関係計算のキャンセル | ユーザーがキャンセルした場合、処理を中断し現在の選択状態を維持 |
| 循環依存 | HashSetを使用して訪問済みメンバーを追跡し、無限ループを防止 |
| IsCheckable=false | 選択操作の対象から除外（フィールドのインターフェース移動など） |

## 備考

- DataGridのSelectionModeはExtendedで複数選択対応
- ThemedImageSourceConverterでアイコンのテーマ対応を実現
- VSThemeDictionary.xamlを参照しており、Visual Studioのテーマに対応
- CanUserSortColumns=Falseでソート機能は無効化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メンバー情報を保持するViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/CommonControls/MemberSelectionViewModel.cs` | Members/CheckedMembers管理、依存関係計算、宛先タイプによるUI調整 |
| 1-2 | MemberSymbolViewModel.cs | `src/VisualStudio/Core/Def/Utilities/MemberSymbolViewModel.cs` | IsChecked/IsCheckable/MakeAbstract/IsMakeAbstractCheckableプロパティ |

**読解のコツ**:
- `UpdateMembersBasedOnDestinationKind`メソッドで宛先の型種別（Class/Interface）に応じてUIが調整される
- フィールドはインターフェースに移動できないため、IsCheckable=falseになる

#### Step 2: エントリーポイントを理解する

XAML定義とコードビハインドでUIの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MemberSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` | DataGridの3列構成（チェック/メンバー/MakeAbstract）、ボタン群 |
| 2-2 | MemberSelection.xaml.cs | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml.cs` | イベントハンドラ、AbstractColumn表示更新 |

**主要処理フロー**:
1. **行24-34**: コンストラクタでViewModelを設定し、PropertyChangedイベントを購読
2. **行36-42**: PropertyChangedでShowMakeAbstractの変更を監視
3. **行44-47**: UpdateAbstractColumnVisibilityでAbstractColumnの表示制御
4. **行49-59**: 各ボタンのクリックイベントハンドラ

#### Step 3: 宛先タイプによるUI調整を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/CommonControls/MemberSelectionViewModel.cs` | UpdateMembersBasedOnDestinationKindメソッド（行138-156） |

**主要処理フロー**:
- **行140-142**: フィールドとMakeAbstract対象の分類
- **行143-149**: インターフェース宛先時のフィールド無効化
- **行151-155**: インターフェース宛先時のMakeAbstract無効化

### プログラム呼び出し階層図

```
MemberSelection (UserControl)
    │
    ├─ MemberSelectionViewModel
    │      ├─ Members (ImmutableArray<MemberSymbolViewModel>)
    │      │      └─ PropertyChanged購読
    │      │
    │      ├─ SelectAll() → IsCheckableのメンバーを全選択
    │      ├─ DeselectAll() → 全メンバー選択解除
    │      ├─ SelectPublic() → Accessibility.Publicのみ選択
    │      │
    │      ├─ SelectDependents()
    │      │      ├─ UIThreadOperationExecutor.Execute()
    │      │      └─ FindDependentsRecursively()
    │      │
    │      └─ UpdateMembersBasedOnDestinationKind()
    │             ├─ フィールドのIsCheckable制御
    │             └─ MakeAbstract列の表示制御
    │
    └─ MemberSymbolViewModel
           ├─ IsChecked (選択状態)
           ├─ IsCheckable (選択可否)
           ├─ MakeAbstract (抽象化フラグ)
           ├─ IsMakeAbstractCheckable (抽象化可否)
           ├─ SymbolName (表示名)
           └─ Glyph (アイコン)
```

### データフロー図

```
[入力]                      [処理]                            [出力]

メンバー一覧 ─────────▶ MemberSelectionViewModel ─────────▶ CheckedMembers
(ISymbol[])                │                                  (選択済みメンバー)
                           │
宛先タイプ ───────────▶ UpdateMembersBasedOnDestinationKind
(Class/Interface)          │
                           ├─ IsCheckable更新 ───────────▶ UI無効化
                           └─ IsMakeAbstractCheckable ───▶ 列表示制御

依存関係マップ ───────▶ FindDependentsRecursively ───────▶ 自動選択
(symbolToDependentsMap)    │
                           └─ BFS探索

GetSelectedMembers()   ────────────────────────────────▶ (member, makeAbstract)[]
                                                          選択結果タプル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MemberSelection.xaml | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` | XAML | UI定義 |
| MemberSelection.xaml.cs | `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml.cs` | ソース | コードビハインド |
| MemberSelectionViewModel.cs | `src/VisualStudio/Core/Def/CommonControls/MemberSelectionViewModel.cs` | ソース | ViewModel実装 |
| MemberSymbolViewModel.cs | `src/VisualStudio/Core/Def/Utilities/MemberSymbolViewModel.cs` | ソース | メンバー表示ViewModel |
| ExtractClassDialog.xaml | `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml` | XAML | 利用元ダイアログ |
| ExtractInterfaceDialog.xaml | `src/VisualStudio/Core/Def/ExtractInterface/ExtractInterfaceDialog.xaml` | XAML | 利用元ダイアログ |
| PullMemberUpDialog.xaml | `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml` | XAML | 利用元ダイアログ |
| VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | XAML | テーマリソース |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
