# 画面設計書 14-ドキュメントアウトラインビュー

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「ドキュメントアウトラインビュー」の画面設計を記述するものである。

### 本画面の処理概要

ドキュメントアウトラインビュー（DocumentOutlineView）は、現在開いているコードファイル内のシンボル構造（クラス、メソッド、プロパティなど）をツリー形式で表示するツールウィンドウである。開発者がコードの全体構造を把握し、特定のシンボルに素早くナビゲートすることを支援する。

**業務上の目的・背景**：
大規模なコードファイルを編集する際、ファイル内のシンボル構造を俯瞰的に把握することは困難である。本ビューは、ドキュメント内のすべてのシンボルをツリー構造で表示し、名前・位置・種類による並べ替え機能と検索機能を提供することで、開発者の生産性を向上させる。また、エディタ内のカーソル位置と連動してツリー内の対応するシンボルを自動選択する機能により、現在の編集位置を常に把握できる。

**画面へのアクセス方法**：
1. Visual Studioのメニューから「表示」>「ドキュメントアウトライン」を選択
2. ツールウィンドウとして表示される
3. アクティブなエディタのドキュメントに対応するシンボルツリーが表示される

**主要な操作・処理内容**：
1. シンボルツリーの表示：ドキュメント内のシンボルを階層構造で表示
2. ソート機能：名前順、位置順、種類順の3種類で並べ替え
3. 検索機能：シンボル名でフィルタリング
4. 展開/折りたたみ：ツリーの全展開/全折りたたみ
5. ナビゲーション：シンボル選択時にエディタ内の対応位置に移動
6. カーソル連動：エディタ内のカーソル位置に対応するシンボルを自動選択

**画面遷移**：
- 遷移元：Visual Studioの表示メニュー
- 遷移先：シンボル選択時にエディタ内の対応位置へナビゲート

**権限による表示制御**：
特別な権限制御はなし。ツールウィンドウはすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | コード構造 | 主機能 | ドキュメント内のシンボル構造のツリー表示・検索・ソート |
| 16 | ナビゲーション | 補助機能 | シンボル選択時のコード位置へのナビゲーション |

## 画面種別

ツールウィンドウ（ツリー表示）

## URL/ルーティング

N/A（Visual Studioツールウィンドウとして実装）

## 入出力項目

### 入力（内部データ）

| 項目名 | 型 | 説明 |
|--------|------|------|
| DocumentSymbolViewModelItems | ImmutableArray&lt;DocumentSymbolDataViewModel&gt; | ドキュメント内のシンボル一覧 |
| SearchText | string | 検索テキスト |
| SortOption | SortOption | ソートオプション（Name/Location/Type） |

### 出力（ユーザー操作）

| 項目名 | 説明 |
|--------|------|
| ナビゲーション | 選択したシンボルの位置へエディタを移動 |

## 表示項目

### ツールバー（CommandsContentControl）

| 項目名 | コマンドID | 説明 |
|--------|-----------|------|
| 全展開 | DocumentOutlineExpandAll | ツリーを全展開 |
| 全折りたたみ | DocumentOutlineCollapseAll | ツリーを全折りたたみ |
| 名前順ソート | DocumentOutlineSortByName | 名前でアルファベット順にソート |
| 位置順ソート | DocumentOutlineSortByOrder | ファイル内の位置順にソート |
| 種類順ソート | DocumentOutlineSortByType | シンボル種類でソート |

### 検索ボックス（SearchHostGrid）

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | IVsWindowSearchHostによる検索UI |

### シンボルツリー（SymbolTree）

| 項目名 | バインディング | 説明 |
|--------|---------------|------|
| シンボルアイコン | ImageMoniker | シンボル種別を示すアイコン |
| シンボル名 | Data.Name | シンボルの名前 |
| 選択インジケーター | IsSelected | 選択状態を示すボーダー |

## イベント仕様

### 1-シンボル選択（ユーザー操作）

1. ユーザーがTreeViewItemをキーボードまたはマウスで選択
2. `SymbolTree_SourceUpdated`イベントが発生
3. キーボードフォーカスが選択アイテム内にあることを確認
4. `IsNavigating`フラグをtrueに設定（再入防止）
5. ViewTrackerからアクティブなテキストビューを取得
6. `TryMoveCaretToAndEnsureVisible`でカーソルを移動し、画面中央に表示
7. `IsNavigating`フラグをfalseにリセット

### 2-カーソル移動連動

1. エディタ内でカーソルが移動
2. `ViewTracker_CaretMovedOrActiveViewChanged`イベントが発生
3. `ExpandAndSelectItemAtCaretPosition`が呼び出される
4. カーソル位置に対応するシンボルを検索
5. 対応するツリーアイテムを選択・展開

### 3-ソート変更

1. ツールバーのソートボタンをクリック
2. `IOleCommandTarget.Exec`が呼び出される
3. `UpdateSort`メソッドでソートオプションを更新
4. CollectionViewSourceのSortDescriptionsを更新
5. ツリーの表示が再構成される

### 4-検索実行

1. 検索ボックスにテキストを入力
2. `IVsWindowSearch.CreateSearch`が呼び出される
3. `ViewModel.SearchText`が更新される
4. 非同期でシンボルのフィルタリングが実行される
5. マッチするシンボルのみがツリーに表示される

## データベース更新仕様

N/A（本ビューはデータベースとの直接的なやり取りは行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| - | ウォーターマーク | "Document Outline Search" | 検索ボックスが空の場合 |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| ドキュメントにシンボルがない | 空のツリーを表示 |
| LSPレスポンスがnull | 空のシンボル一覧を使用 |
| ビュー非表示時の更新 | 更新をキューに入れ、表示時に再実行 |

## 備考

- VirtualizingTreeViewを使用して大量のシンボルでもパフォーマンスを維持
- ImmutableIntervalTreeを使用して高速なシンボル検索を実現
- LSP（Language Server Protocol）経由でシンボル情報を取得
- ソートオプションはグローバルオプションに保存され、セッション間で維持
- TaggerEventSourcesを使用してドキュメント変更を監視

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シンボル情報を保持するViewModelの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DocumentOutlineViewModel.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineViewModel.cs` | DocumentSymbolViewModelItems、SearchText、SortOption、非同期更新キュー |
| 1-2 | DocumentSymbolDataViewModel.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentSymbolDataViewModel.cs` | 個々のシンボルの表示情報、Children階層構造 |

**読解のコツ**:
- `AsyncBatchingWorkQueue`による非同期モデル更新の仕組みを理解
- `ImmutableIntervalTree`によるシンボル検索の最適化に注目

#### Step 2: エントリーポイントを理解する

XAML定義とコードビハインドでUIの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DocumentOutlineView.xaml | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml` | ツールバー/検索/ツリーの3行レイアウト、HierarchicalDataTemplate |
| 2-2 | DocumentOutlineView.xaml.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml.cs` | IOleCommandTarget実装、IVsWindowSearch実装、イベントハンドラ |

**主要処理フロー**:
1. **行46-78**: コンストラクタでツールバー/検索ホストを初期化
2. **行80-109**: PreviewKeyDownでフォーカス移動を制御
3. **行169-198**: Execメソッドでコマンド実行（ソート/展開折りたたみ）
4. **行312-345**: SymbolTree_SourceUpdatedでシンボル選択時のナビゲーション

#### Step 3: 非同期更新ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DocumentOutlineViewModel.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineViewModel.cs` | ComputeViewStateAsync（行251-342）、UpdateSelectionAsync（行439-479） |

**主要処理フロー**:
- **行269**: LSPでドキュメントシンボルを取得
- **行296-297**: 検索テキストでフィルタリング
- **行303-310**: 前回状態から展開/選択状態を引き継ぎ
- **行316**: ImmutableIntervalTree構築

### プログラム呼び出し階層図

```
DocumentOutlineView (UserControl)
    │
    ├─ IOleCommandTarget
    │      ├─ QueryStatus() → コマンド状態を返す
    │      └─ Exec() → UpdateSort() / ExpandOrCollapseAll()
    │
    ├─ IVsWindowSearch
    │      ├─ CreateSearch() → ViewModel.SearchText設定
    │      ├─ ClearSearch() → SearchTextクリア
    │      └─ ProvideSearchSettings() → 検索UI設定
    │
    ├─ DocumentOutlineViewModel
    │      ├─ _workQueue (AsyncBatchingWorkQueue)
    │      │      └─ ComputeViewStateAsync()
    │      │             ├─ ComputeDocumentSymbolDataAsync() [LSP呼び出し]
    │      │             ├─ SearchDocumentSymbolData() [フィルタリング]
    │      │             └─ GetDocumentSymbolItemViewModels() [VM生成]
    │      │
    │      ├─ _selectionQueue (AsyncBatchingWorkQueue)
    │      │      └─ UpdateSelectionAsync()
    │      │             └─ ImmutableIntervalTree.GetIntervalsThatOverlapWith()
    │      │
    │      └─ DocumentSymbolViewModelItems
    │             └─ CollectionViewSource経由でTreeViewにバインド
    │
    └─ VsCodeWindowViewTracker
           └─ CaretMovedOrActiveViewChanged → ExpandAndSelectItemAtCaretPosition()
```

### データフロー図

```
[入力]                       [処理]                              [出力]

エディタドキュメント        LSP DocumentSymbolRequest           シンボルツリー表示
      │                            │                                  ▲
      ▼                            ▼                                  │
ITextBuffer ──────────▶ DocumentSymbolData[] ─────────────▶ ViewModelItems
                              │
検索テキスト ─────────────────┤
(SearchText)                  │
                              ▼
                    SearchDocumentSymbolData()
                              │
                              ▼
ソートオプション ─────▶ GetDocumentSymbolItemViewModels()
(SortOption)                  │
                              ▼
                    CollectionViewSource.SortDescriptions
                              │
                              ▼
                         TreeView表示

カーソル位置 ─────────▶ ImmutableIntervalTree ──────────▶ 自動選択/展開
(CaretPosition)            検索
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DocumentOutlineView.xaml | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml` | XAML | UI定義 |
| DocumentOutlineView.xaml.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineView.xaml.cs` | ソース | コードビハインド、コマンド実装 |
| DocumentOutlineViewModel.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineViewModel.cs` | ソース | ViewModel実装 |
| DocumentSymbolDataViewModel.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentSymbolDataViewModel.cs` | ソース | シンボル表示ViewModel |
| VirtualizingTreeView.cs | `src/VisualStudio/Core/Def/DocumentOutline/VirtualizingTreeView.cs` | ソース | 仮想化TreeView |
| DocumentSymbolDataViewModelSorter.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentSymbolDataViewModelSorter.cs` | ソース | ソート実装 |
| VsCodeWindowViewTracker.cs | `src/VisualStudio/Core/Def/DocumentOutline/VsCodeWindowViewTracker.cs` | ソース | エディタ追跡 |
| DocumentOutlineOptionsStorage.cs | `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineOptionsStorage.cs` | ソース | オプション永続化 |
| VSThemeDictionary.xaml | `src/VisualStudio/Core/Def/VSThemeDictionary.xaml` | XAML | テーマリソース |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
