# 画面設計書 15-値追跡ルートビュー

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「値追跡ルートビュー」の画面設計を記述するものである。

### 本画面の処理概要

値追跡ルートビュー（ValueTrackingRoot）は、値追跡機能のツールウィンドウのルートコンテナとして機能する。変数やパラメータの値がどこから来ているか（データフローの追跡）を視覚化する機能の基盤となるビューである。

**業務上の目的・背景**：
デバッグや問題解析において、特定の変数がどこで値を取得したのか、あるいはどこに値を渡しているのかを追跡することは重要な作業である。本ビューは、値追跡機能のエントリーポイントとして、追跡結果を表示するための子ビュー（ValueTrackingTree）をホストする。追跡対象が選択されていない場合は、ユーザーにガイダンスメッセージを表示する。

**画面へのアクセス方法**：
1. Visual Studioのメニューから「表示」>「値追跡」を選択
2. または、エディタ内で変数を右クリックし「値の追跡」を選択
3. ツールウィンドウとして表示される

**主要な操作・処理内容**：
1. 空状態の表示：追跡対象が選択されていない場合、ガイダンスメッセージを表示
2. 子ビューのホスト：ValueTrackingTreeビューを動的に配置
3. 状態切り替え：追跡開始/終了に応じてビューを切り替え

**画面遷移**：
- 遷移元：Visual Studioの表示メニュー、エディタのコンテキストメニュー
- 遷移先：値追跡ツリービュー（ValueTrackingTree）を子として表示

**権限による表示制御**：
特別な権限制御はなし。ツールウィンドウはすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 値追跡 | 主機能 | 値追跡機能のツールウィンドウのルートコンテナ |

## 画面種別

ツールウィンドウ（コンテナビュー）

## URL/ルーティング

N/A（Visual Studioツールウィンドウとして実装）

## 入出力項目

### 内部状態

| 項目名 | 型 | 説明 |
|--------|------|------|
| EmptyText | string | 空状態時のガイダンスメッセージ |
| RootGrid.Children | UIElementCollection | 子ビューのコレクション |

## 表示項目

### 空状態表示

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| ガイダンスメッセージ | TextBlock (EmptyTextMessage) | EmptyText | 「Select an appropriate symbol to start value tracking」 |

### 追跡結果表示

| 項目名 | 説明 |
|--------|------|
| ValueTrackingTree | 追跡結果をツリー形式で表示する子ビュー |

## イベント仕様

### 1-SetChild呼び出し（子ビュー設定）

1. 外部から`SetChild`メソッドが呼び出される
2. `RootGrid.Children.Clear()`で既存の子をクリア
3. 引数がnullの場合：
   - `EmptyTextMessage`を追加
   - `EmptyTextMessage.Visibility = Visible`に設定
4. 引数がnull以外の場合：
   - `EmptyTextMessage.Visibility = Collapsed`に設定
   - 渡された子ビューを追加

## データベース更新仕様

N/A（本ビューはデータベースとの直接的なやり取りは行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| - | ガイダンス | "Select an appropriate symbol to start value tracking" | 追跡対象が選択されていない場合 |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| 子ビューがnull | EmptyTextMessageを表示 |

## 備考

- 非常にシンプルなコンテナビューであり、主要な機能はValueTrackingTreeに委譲
- ThemedDialogDefaultStylesKeyを使用してVisual Studioのテーマに対応
- Gridコントロール（RootGrid）が子ビューのホストとして機能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ルートビューは非常にシンプルなため、主に子ビュー（ValueTrackingTree）のViewModelを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ValueTrackingTreeViewModel.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTreeViewModel.cs` | Roots、SelectedItem、IsLoading、ShowDetails |

**読解のコツ**:
- 本ビュー自体はViewModelを持たず、子ビューにViewModelを委譲

#### Step 2: エントリーポイントを理解する

XAML定義とコードビハインドでUIの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ValueTrackingRoot.xaml | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml` | シンプルなGrid内にTextBlock配置 |
| 2-2 | ValueTrackingRoot.xaml.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml.cs` | SetChildメソッドによる子ビュー切り替え |

**主要処理フロー**:
1. **行15**: EmptyTextプロパティでガイダンスメッセージを定義
2. **行17-20**: コンストラクタでInitializeComponent
3. **行22-36**: SetChildメソッドで子ビューを動的に設定

### プログラム呼び出し階層図

```
ValueTrackingRoot (UserControl)
    │
    ├─ RootGrid (Grid)
    │      └─ Children
    │             ├─ EmptyTextMessage (TextBlock) [初期状態]
    │             └─ ValueTrackingTree [追跡開始時]
    │
    └─ SetChild(FrameworkElement? child)
           ├─ child == null → EmptyTextMessage表示
           └─ child != null → child表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

値追跡開始 ──────────▶ ValueTrackingToolWindow ───▶ SetChild(ValueTrackingTree)
(ユーザー操作)              │                              │
                           │                              ▼
                           │                      RootGrid.Children更新
                           │                              │
値追跡終了/              ──▶ SetChild(null)                │
クリア                                                     ▼
                                                   EmptyTextMessage表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ValueTrackingRoot.xaml | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml` | XAML | UI定義 |
| ValueTrackingRoot.xaml.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingRoot.xaml.cs` | ソース | コードビハインド |
| ValueTrackingTree.xaml | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml` | XAML | 子ビュー定義 |
| ValueTrackingTreeViewModel.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTreeViewModel.cs` | ソース | 子ビューViewModel |
| ValueTrackingToolWindow.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingToolWindow.cs` | ソース | ツールウィンドウホスト |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
