# 画面設計書 16-値追跡ツリービュー

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「値追跡ツリービュー」の画面設計を記述するものである。

### 本画面の処理概要

値追跡ツリービュー（ValueTrackingTree）は、変数やパラメータの値の流れを追跡した結果をツリー形式で表示するビューである。データフローの上流（値の取得元）や下流（値の渡し先）を階層的に表示し、コードナビゲーション機能を提供する。

**業務上の目的・背景**：
複雑なコードベースにおいて、変数の値がどこから来ているのか、あるいはどこで使用されているのかを追跡することは、バグの原因調査やコード理解において非常に重要である。本ビューは、追跡結果をツリー構造で視覚化し、各ノードをダブルクリックまたはEnterキーで対応するコード位置にナビゲートできる機能を提供する。また、読み込み中の状態表示や選択項目の詳細情報（ファイル名、行番号）も表示する。

**画面へのアクセス方法**：
1. エディタ内で変数やパラメータを選択
2. コンテキストメニューから「値の追跡」を選択
3. ValueTrackingRootビュー内に本ビューが表示される

**主要な操作・処理内容**：
1. ツリー表示：追跡結果を階層構造で表示
2. ノード選択：キーボード（矢印キー、Enter）またはマウスで選択
3. ナビゲーション：選択したノードの対応コード位置に移動
4. 展開/折りたたみ：矢印キーまたはスペースキーでノードを展開/折りたたみ
5. 読み込み中表示：追跡計算中にプログレスバーと「Computing...」ノードを表示
6. 詳細情報表示：選択項目のファイル名と行番号をサイドパネルに表示

**画面遷移**：
- 遷移元：ValueTrackingRootからホストされる
- 遷移先：選択したノードの対応コード位置（エディタ）へナビゲート

**権限による表示制御**：
特別な権限制御はなし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 値追跡 | 主機能 | 変数値の追跡結果をツリー形式で表示 |

## 画面種別

ツールウィンドウ（ツリー表示 + 詳細パネル）

## URL/ルーティング

N/A（Visual Studioツールウィンドウとして実装）

## 入出力項目

### 入力（ViewModel）

| 項目名 | 型 | 説明 |
|--------|------|------|
| Roots | ObservableCollection&lt;TreeItemViewModel&gt; | ツリーのルートノード一覧 |
| IsLoading | bool | 読み込み中フラグ |
| SelectedItem | TreeViewItemBase | 選択中のアイテム |

### 出力（表示）

| 項目名 | 型 | 説明 |
|--------|------|------|
| SelectedItemFile | string | 選択項目のファイル名 |
| SelectedItemLine | int | 選択項目の行番号 |
| ShowDetails | bool | 詳細パネル表示フラグ |

## 表示項目

### プログレスバー

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| 読み込み中 | ProgressBar | IsLoading | 不確定プログレスバー（高さ2px） |

### ツリービュー（ValueTrackingTreeView）

| 項目名 | テンプレート | 説明 |
|--------|-------------|------|
| TreeItemViewModel | HierarchicalDataTemplate | 通常のツリーノード（アイコン+テキスト） |
| EmptyTreeViewItem | DataTemplate | 空のアイテム（非表示） |
| ComputingTreeViewItem | DataTemplate | 読み込み中表示（スピナー+テキスト） |

### 詳細パネル

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| ファイルラベル | Label | - | "File" |
| ファイル名 | Label | SelectedItemFile | 選択項目のファイル名 |
| 行ラベル | Label | - | "Line" |
| 行番号 | Label | SelectedItemLine | 選択項目の行番号 |

## イベント仕様

### 1-キーボードナビゲーション

1. PreviewKeyDownイベントが発生
2. キーに応じた処理を実行：
   - Down: 次のアイテムを選択、expandNode=falseで取得
   - Up: 前のアイテムを選択
   - F8: 次のアイテムを選択してナビゲート（Shift+F8で前のアイテム）
   - Enter: 現在の選択アイテムにナビゲート
   - Right: ノードを展開
   - Left: ノードを折りたたみ
   - Space: ノードの展開/折りたたみをトグル

### 2-マウスダブルクリック

1. PreviewMouseDoubleClickイベントが発生
2. 左ボタンクリックであることを確認
3. クリックされたアイテムを特定
4. SelectItemメソッドでアイテムを選択しナビゲート

### 3-選択変更

1. SelectedItemChangedイベントが発生
2. `_viewModel.SelectedItem`を更新
3. ViewModelのSelf_PropertyChangedハンドラが実行
4. ShowDetails、SelectedItemFile、SelectedItemLineが更新

## データベース更新仕様

N/A（本ビューはデータベースとの直接的なやり取りは行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| - | 読み込み中 | ComputingTreeViewItem.Text | 値追跡計算中 |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| 選択アイテムがnull | ナビゲーションをスキップ |
| TreeItemViewModel以外のアイテム | ナビゲーションをスキップ |

## 備考

- GridSplitterで左右ペインのサイズ調整が可能
- ThemedImageSourceConverterでアイコンのテーマ対応を実現
- ProgressControlでスピナーアニメーションを表示
- BindableTextBlockでInlineCollectionのバインディングを実現
- ツリーナビゲーションはGetNextInTree/GetPreviousInTreeメソッドで実装

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ツリーノードを表すViewModelの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ValueTrackingTreeViewModel.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTreeViewModel.cs` | Roots、SelectedItem、IsLoading、ShowDetails、SelectedItemFile/Line |
| 1-2 | TreeViewItemBase.cs | `src/VisualStudio/Core/Def/ValueTracking/TreeViewItemBase.cs` | IsNodeExpanded、IsNodeSelected、GetNextInTree、GetPreviousInTree |
| 1-3 | TreeItemViewModel.cs | `src/VisualStudio/Core/Def/ValueTracking/TreeItemViewModel.cs` | ChildItems、FileName、LineNumber、NavigateTo |

**読解のコツ**:
- `TreeViewItemBase`がツリーナビゲーションの基本ロジックを提供
- `TreeItemViewModel`がシンボル情報とナビゲーション機能を持つ

#### Step 2: エントリーポイントを理解する

XAML定義とコードビハインドでUIの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ValueTrackingTree.xaml | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml` | 3列Grid（ツリー/スプリッター/詳細）、HierarchicalDataTemplate、DataTemplate |
| 2-2 | ValueTrackingTree.xaml.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml.cs` | キーボードイベント処理、マウスダブルクリック処理 |

**主要処理フロー**:
1. **行23-65**: PreviewKeyDownでキーボードナビゲーション
2. **行67-84**: MouseDoubleClickでダブルクリックナビゲーション
3. **行86-94**: SelectItemでナビゲーション実行

### プログラム呼び出し階層図

```
ValueTrackingTree (UserControl)
    │
    ├─ ValueTrackingTreeViewModel
    │      ├─ Roots (ObservableCollection<TreeItemViewModel>)
    │      ├─ SelectedItem ─────▶ Self_PropertyChanged
    │      │                          ├─ ShowDetails更新
    │      │                          ├─ SelectedItemFile更新
    │      │                          └─ SelectedItemLine更新
    │      │
    │      └─ IsLoading ─────────▶ LoadingCount監視
    │
    ├─ PreviewKeyDown
    │      ├─ Down/Up → GetNextItem/GetPreviousItem
    │      ├─ F8 → GetNextItem + NavigateTo
    │      ├─ Enter → NavigateTo
    │      ├─ Right → IsNodeExpanded = true
    │      ├─ Left → IsNodeExpanded = false
    │      └─ Space → IsNodeExpanded toggle
    │
    └─ MouseDoubleClick
           └─ SelectItem(navigate: true)
                  └─ TreeItemViewModel.NavigateTo()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

値追跡開始 ───────────▶ ValueTrackingService ─────────▶ Roots更新
(シンボル選択)               │                              (ツリー表示)
                            │
                            ▼
                     TreeItemViewModel生成
                            │
                            ▼
ユーザー操作 ─────────▶ SelectItem()
(キー/マウス)               │
                            ├─▶ SelectedItem更新 ─────▶ 詳細パネル更新
                            │
                            └─▶ NavigateTo() ─────────▶ エディタナビゲーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ValueTrackingTree.xaml | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml` | XAML | UI定義 |
| ValueTrackingTree.xaml.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTree.xaml.cs` | ソース | コードビハインド |
| ValueTrackingTreeViewModel.cs | `src/VisualStudio/Core/Def/ValueTracking/ValueTrackingTreeViewModel.cs` | ソース | ViewModel実装 |
| TreeViewItemBase.cs | `src/VisualStudio/Core/Def/ValueTracking/TreeViewItemBase.cs` | ソース | ツリーアイテム基底クラス |
| TreeItemViewModel.cs | `src/VisualStudio/Core/Def/ValueTracking/TreeItemViewModel.cs` | ソース | シンボルノードViewModel |
| ComputingTreeViewItem.cs | `src/VisualStudio/Core/Def/ValueTracking/ComputingTreeViewItem.cs` | ソース | 読み込み中アイテム |
| EmptyTreeViewItem.cs | `src/VisualStudio/Core/Def/ValueTracking/EmptyTreeViewItem.cs` | ソース | 空アイテム |
| BindableTextBlock.cs | `src/VisualStudio/Core/Def/Utilities/BindableTextBlock.cs` | ソース | Inline対応TextBlock |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
