# 画面設計書 17-スタックトレースエクスプローラールート

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「スタックトレースエクスプローラールート」の画面設計を記述するものである。

### 本画面の処理概要

スタックトレースエクスプローラールート（StackTraceExplorerRoot）は、スタックトレース解析機能のツールウィンドウのルートコンテナとして機能する。複数のスタックトレースをタブ形式で管理し、クリップボードからのペースト操作で新しいスタックトレースを解析・表示する機能を提供する。

**業務上の目的・背景**：
アプリケーションの例外発生時やログ解析時に、スタックトレースを解析してコード位置を特定することは頻繁に行われる作業である。本ビューは、テキスト形式のスタックトレースをクリップボードからペーストすることで、各フレームを解析し、対応するコード位置へのナビゲーションを可能にする。複数のスタックトレースをタブで管理できるため、関連する複数のスタックトレースを比較しながら調査することもできる。

**画面へのアクセス方法**：
1. Visual Studioのメニューから「表示」>「スタックトレースエクスプローラー」を選択
2. ツールウィンドウとして表示される
3. スタックトレースをクリップボードにコピーし、Ctrl+Vでペースト

**主要な操作・処理内容**：
1. ペースト操作：クリップボードからスタックトレースをペースト
2. タブ管理：複数のスタックトレースをタブで管理
3. タブクローズ：不要なタブを閉じる
4. クリア操作：現在のタブのスタックトレースをクリア
5. タブ選択：複数のタブ間を切り替え

**画面遷移**：
- 遷移元：Visual Studioの表示メニュー
- 遷移先：各タブ内にStackTraceExplorerビューを表示

**権限による表示制御**：
特別な権限制御はなし。ツールウィンドウはすべてのユーザーが利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | スタックトレース探索 | 主機能 | スタックトレース解析のタブ管理とペースト処理 |

## 画面種別

ツールウィンドウ（タブコンテナ）

## URL/ルーティング

N/A（Visual Studioツールウィンドウとして実装）

## 入出力項目

### 入力（ViewModel）

| 項目名 | 型 | 説明 |
|--------|------|------|
| Tabs | ObservableCollection&lt;StackTraceExplorerTab&gt; | タブ一覧 |
| SelectedTab | StackTraceExplorerTab | 選択中のタブ |

### 出力（表示）

| 項目名 | 説明 |
|--------|------|
| タブ一覧 | スタックトレースごとのタブ |
| クリアボタン | スタックトレースをクリア |

## 表示項目

### ツールバー（StackPanel）

| 項目名 | コントロール | 説明 |
|--------|-------------|------|
| クリアボタン | Button (ClearButton) | 現在のタブをクリア |
| クリアアイコン | CrispImage | KnownMonikers.ClearCollection |
| クリアテキスト | TextBlock | "Clear" |

### タブコントロール

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| タブ一覧 | TabControl | Tabs | スタックトレースタブのコレクション |
| 選択タブ | - | SelectedTab (TwoWay) | 現在選択中のタブ |

### タブアイテム

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| タブヘッダー | ContentPresenter | Header | タブ名（"Stack Trace N"） |
| 閉じるボタン | Button | CloseClick | タブを閉じるコマンド |
| 閉じるアイコン | CrispImage | KnownMonikers.Close | 閉じるアイコン（14x14） |
| 選択インジケーター | Rectangle | - | 選択状態を示す下線 |
| タブコンテンツ | - | Content | StackTraceExplorerビュー |

## イベント仕様

### 1-ペースト操作

1. Ctrl+Vまたはペーストコマンド実行
2. `OnPaste`ハンドラ（DataObjectPastingHandler）が発生
3. `ViewModel.DoPasteAsync`が呼び出される
4. クリップボードからテキストを取得
5. テキストが空でない場合：
   - 選択中のタブが空の場合：そのタブに結果を設定
   - そうでない場合：新しいタブを追加
6. `StackTraceAnalyzer.AnalyzeAsync`でスタックトレースを解析
7. 結果をタブコンテンツに設定

### 2-クリア操作

1. クリアボタン押下
2. `Clear_Click`ハンドラが実行
3. `OnClear`メソッドが呼び出される
4. 選択中のタブのコンテンツに対して`OnClear`を実行

### 3-タブクローズ

1. タブの閉じるボタン押下
2. `CloseClick`コマンドが実行
3. `Tab_Closed`イベントハンドラが発生
4. タブをコレクションから削除
5. イベントハンドラを解除

### 4-新規タブ追加

1. ペースト操作時に`AddNewTabAsync`が呼び出される
2. 現在の最大インデックス+1でタブ名を設定
3. 新しい`StackTraceExplorerTab`を作成
4. タブコレクションに追加
5. 新しいタブを選択状態に設定
6. `OnClosed`イベントを購読

## データベース更新仕様

N/A（本ビューはデータベースとの直接的なやり取りは行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| - | ラベル | "Clear" | クリアボタンのテキスト |
| - | ラベル | "Stack Trace" | アクセシビリティ名 |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| クリップボードが空 | ペースト処理をスキップ |
| 解析結果がnull | 空のタブを表示 |

## 備考

- タブヘッダーはScrollViewerでラップされており、水平スクロールが可能
- タブアイテムのスタイルは完全にカスタマイズされている
- TabControl.Templateでスクロール可能なタブヘッダーを実現
- タブ選択時に下線（_underline Rectangle）が表示される
- BrushToColorConverterでボタン背景色を変換

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タブ管理を行うViewModelの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StackTraceExplorerRootViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRootViewModel.cs` | Tabs、SelectedTab、DoPasteAsync、AddNewTabAsync |
| 1-2 | StackTraceExplorerTab.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerTab.cs` | Header、Content、CloseClick、OnClosed |

**読解のコツ**:
- `ObservableCollection<StackTraceExplorerTab>`でタブを管理
- 各タブは`StackTraceExplorer`ビューをContentとして保持

#### Step 2: エントリーポイントを理解する

XAML定義とコードビハインドでUIの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StackTraceExplorerRoot.xaml | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml` | ToolbarのStackPanel、カスタムTabControl.Template、タブアイテムスタイル |
| 2-2 | StackTraceExplorerRoot.xaml.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml.cs` | ペーストハンドラ、クリアボタンハンドラ |

**主要処理フロー**:
1. **行22-28**: コンストラクタでPastingHandlerを登録
2. **行30-31**: CommandBinding_OnPasteでペースト実行
3. **行33-36**: OnClearで選択タブのクリア
4. **行38-39**: OnPasteハンドラ

### プログラム呼び出し階層図

```
StackTraceExplorerRoot (UserControl)
    │
    ├─ StackTraceExplorerRootViewModel
    │      ├─ Tabs (ObservableCollection<StackTraceExplorerTab>)
    │      ├─ SelectedTab
    │      │
    │      ├─ DoPasteAsync()
    │      │      ├─ Clipboard.GetText()
    │      │      ├─ StackTraceAnalyzer.AnalyzeAsync()
    │      │      └─ AddNewTabAsync() または SetStackTraceResultAsync()
    │      │
    │      ├─ AddNewTabAsync()
    │      │      ├─ new StackTraceExplorerTab()
    │      │      ├─ Tabs.Add()
    │      │      └─ SelectedTab = newTab
    │      │
    │      └─ ContainsTab(text) → 重複チェック
    │
    └─ StackTraceExplorerTab
           ├─ Header (タブ名)
           ├─ Content (StackTraceExplorer)
           ├─ CloseClick (ICommand)
           └─ OnClosed (event)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Ctrl+V / ペースト ─────▶ Clipboard.GetText() ──────────▶ テキスト取得
                              │
                              ▼
                    StackTraceAnalyzer.AnalyzeAsync()
                              │
                              ▼
                    StackTraceAnalysisResult
                              │
                              ├─▶ 新規タブ追加 ────────────▶ Tabs.Add()
                              │      └─ SelectedTab設定
                              │
                              └─▶ 既存タブ更新 ────────────▶ SetStackTraceResultAsync()

クリアボタン ─────────▶ OnClear() ─────────────────────▶ SelectedTab.OnClear()

タブ閉じる ───────────▶ Tab_Closed() ──────────────────▶ Tabs.Remove()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StackTraceExplorerRoot.xaml | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml` | XAML | UI定義 |
| StackTraceExplorerRoot.xaml.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRoot.xaml.cs` | ソース | コードビハインド |
| StackTraceExplorerRootViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerRootViewModel.cs` | ソース | ViewModel実装 |
| StackTraceExplorerTab.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerTab.cs` | ソース | タブ管理クラス |
| StackTraceExplorer.xaml | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml` | XAML | 子ビュー定義 |
| StackTraceAnalyzer.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceAnalyzer.cs` | ソース | スタックトレース解析 |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
