# 画面設計書 18-スタックトレースエクスプローラー

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「スタックトレースエクスプローラー」の画面設計を記述するものである。

### 本画面の処理概要

スタックトレースエクスプローラー（StackTraceExplorer）は、解析されたスタックトレースのフレーム一覧を表示し、各フレームに対応するコード位置へのナビゲーション機能を提供するビューである。

**業務上の目的・背景**：
スタックトレースを解析した結果、各フレーム（メソッド呼び出し）をリスト形式で表示し、開発者がダブルクリックで対応するソースコードの位置に素早くナビゲートできるようにする。これにより、例外発生箇所の特定やコールスタックの追跡が効率的に行える。

**画面へのアクセス方法**：
本ビューは単体では使用されず、StackTraceExplorerRootのタブコンテンツとして表示される。

**主要な操作・処理内容**：
1. フレーム一覧表示：解析されたスタックフレームをリスト表示
2. ペースト操作：クリップボードからスタックトレースをペースト
3. ナビゲーション：フレームをダブルクリックして対応コード位置に移動
4. クリア操作：フレーム一覧をクリア
5. ガイダンス表示：フレームがない場合に「Paste valid stack trace」を表示

**画面遷移**：
- 遷移元：StackTraceExplorerRootのタブコンテンツ
- 遷移先：選択したフレームの対応コード位置（エディタ）へナビゲート

**権限による表示制御**：
特別な権限制御はなし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | スタックトレース探索 | 主機能 | スタックトレースフレームの表示とコードナビゲーション |

## 画面種別

リストビュー

## URL/ルーティング

N/A（Visual Studioツールウィンドウの子ビューとして実装）

## 入出力項目

### 入力（ViewModel）

| 項目名 | 型 | 説明 |
|--------|------|------|
| Frames | ObservableCollection&lt;FrameViewModel&gt; | フレーム一覧 |
| Selection | FrameViewModel | 選択中のフレーム |
| IsLoading | bool | 読み込み中フラグ |

### 出力（表示）

| 項目名 | 型 | 説明 |
|--------|------|------|
| IsListVisible | bool | リスト表示フラグ（Frames.Count > 0） |
| IsInstructionTextVisible | bool | ガイダンス表示フラグ（Frames.Count == 0） |
| InstructionText | string | ガイダンスメッセージ |

## 表示項目

### フレームリスト（ListView）

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| フレームリスト | ListView | Frames | スタックフレームのコレクション |
| 選択アイテム | - | Selection (TwoWay) | 選択中のフレーム |

### フレームアイテム（DataTemplate）

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| フレームテキスト | BindableTextBlock | Inlines | 色分けされたフレーム表示 |

### ガイダンス表示

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| ガイダンステキスト | TextBlock | InstructionText | "Paste valid stack trace" |

## イベント仕様

### 1-ペースト操作

1. Ctrl+Vまたはペーストコマンド実行
2. `CommandBinding_Executed`または`OnPaste`ハンドラが発生
3. `OnPaste`メソッドが呼び出される
4. クリップボードからテキストを取得
5. `ViewModel.OnPaste_CallOnUIThread`を呼び出し
6. バックグラウンドで`StackTraceAnalyzer.AnalyzeAsync`実行
7. 結果を`SetStackTraceResultAsync`でUIに反映

### 2-ダブルクリックナビゲーション

1. ListViewItemでダブルクリック
2. `ListViewItem_MouseDoubleClick`ハンドラが発生
3. 選択アイテムが`StackFrameViewModel`であることを確認
4. `NavigateToSymbol`メソッドを呼び出し
5. 対応するソースコード位置にエディタをナビゲート

### 3-クリア操作

1. 親ビュー（StackTraceExplorerRoot）から`OnClear`が呼び出される
2. `ViewModel.OnClear`を実行
3. `Frames.Clear()`でフレーム一覧をクリア
4. `IsListVisible`がfalseに、`IsInstructionTextVisible`がtrueに変更

### 4-ガイダンステキスト表示変更

1. `TextBlock_IsVisibleChanged`イベントが発生
2. テキストブロックが表示状態の場合
3. AutomationPeerを取得
4. `RaiseAutomationEvent(LiveRegionChanged)`でアクセシビリティイベント発火

## データベース更新仕様

N/A（本ビューはデータベースとの直接的なやり取りは行わない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| - | ガイダンス | "Paste valid stack trace" | フレーム一覧が空の場合 |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| 選択アイテムがStackFrameViewModelでない | ナビゲーションをスキップ |
| クリップボードが空 | 何もしない |

## 備考

- BindableTextBlockでInlineCollectionのバインディングを実現
- CommandBindingsでペーストコマンドを複数箇所で処理
- ListViewItemのスタイルでカスタム選択表示を実現
- ShowMouseOverプロパティでマウスオーバー効果を制御
- AutomationProperties.LiveSetting="Polite"でスクリーンリーダー対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フレーム表示を管理するViewModelの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StackTraceExplorerViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerViewModel.cs` | Frames、Selection、IsListVisible、OnPaste_CallOnUIThread、SetStackTraceResultAsync |
| 1-2 | FrameViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/FrameViewModel.cs` | Inlines、ShowMouseOver |
| 1-3 | StackFrameViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackFrameViewModel.cs` | NavigateToSymbol |

**読解のコツ**:
- `FrameViewModel`は抽象基底クラスで、`StackFrameViewModel`と`IgnoredFrameViewModel`に派生
- ナビゲーション可能なのは`StackFrameViewModel`のみ

#### Step 2: エントリーポイントを理解する

XAML定義とコードビハインドでUIの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StackTraceExplorer.xaml | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml` | ListViewのDataTemplate、CommandBindings、ガイダンスTextBlock |
| 2-2 | StackTraceExplorer.xaml.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml.cs` | ペーストハンドラ、ダブルクリックハンドラ |

**主要処理フロー**:
1. **行23-24**: コンストラクタでPastingHandlerを登録
2. **行26-27**: OnPasteハンドラでペースト処理
3. **行29-30**: CommandBinding_Executedでペースト実行
4. **行32-36**: OnPasteでクリップボードテキスト取得とViewModel呼び出し
5. **行38-44**: ListViewItem_MouseDoubleClickでナビゲーション

### プログラム呼び出し階層図

```
StackTraceExplorer (UserControl)
    │
    ├─ StackTraceExplorerViewModel
    │      ├─ Frames (ObservableCollection<FrameViewModel>)
    │      │      └─ CollectionChanged → IsListVisible/IsInstructionTextVisible更新
    │      │
    │      ├─ OnPaste_CallOnUIThread(text)
    │      │      ├─ IsLoading = true
    │      │      ├─ Frames.Clear()
    │      │      ├─ Task.Run(StackTraceAnalyzer.AnalyzeAsync)
    │      │      └─ SetStackTraceResultAsync()
    │      │
    │      ├─ SetStackTraceResultAsync(result, originalText)
    │      │      └─ Frames.Add(GetViewModel(frame))
    │      │
    │      └─ OnClear()
    │             └─ Frames.Clear()
    │
    ├─ FrameViewModel
    │      ├─ IgnoredFrameViewModel (解析不能なフレーム)
    │      └─ StackFrameViewModel (ナビゲーション可能)
    │             └─ NavigateToSymbol()
    │
    └─ CommandBindings
           └─ Paste → OnPaste()
```

### データフロー図

```
[入力]                      [処理]                            [出力]

Ctrl+V / ペースト ─────▶ Clipboard.GetText() ───────────▶ テキスト取得
                              │
                              ▼
                    OnPaste_CallOnUIThread()
                              │
                              ├─ IsLoading = true
                              │
                              ▼
                    StackTraceAnalyzer.AnalyzeAsync()
                              │
                              ▼
                    StackTraceAnalysisResult
                              │
                              ▼
                    GetViewModel(frame)
                              │
                              ├─ StackFrameViewModel ────▶ ナビゲーション可能
                              └─ IgnoredFrameViewModel ──▶ 表示のみ
                              │
                              ▼
                         Frames.Add()
                              │
                              ▼
                         ListView表示

ダブルクリック ─────────▶ NavigateToSymbol() ────────────▶ エディタナビゲーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StackTraceExplorer.xaml | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml` | XAML | UI定義 |
| StackTraceExplorer.xaml.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml.cs` | ソース | コードビハインド |
| StackTraceExplorerViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerViewModel.cs` | ソース | ViewModel実装 |
| FrameViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/FrameViewModel.cs` | ソース | フレーム基底ViewModel |
| StackFrameViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/StackFrameViewModel.cs` | ソース | ナビゲーション可能フレーム |
| IgnoredFrameViewModel.cs | `src/VisualStudio/Core/Def/StackTraceExplorer/IgnoredFrameViewModel.cs` | ソース | 解析不能フレーム |
| StackTraceAnalyzer.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceAnalyzer.cs` | ソース | スタックトレース解析 |
| BindableTextBlock.cs | `src/VisualStudio/Core/Def/Utilities/BindableTextBlock.cs` | ソース | Inline対応TextBlock |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
