# 画面設計書 19-未使用参照削除ダイアログ

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）のVisual Studio拡張機能における「未使用参照削除ダイアログ」の画面設計を記述するものである。

### 本画面の処理概要

未使用参照削除ダイアログ（RemoveUnusedReferencesDialog）は、プロジェクト内で使用されていない参照（プロジェクト参照、パッケージ参照など）を一覧表示し、削除対象として選択・適用する機能を提供するダイアログである。

**業務上の目的・背景**：
プロジェクトの肥大化やビルド時間の増加を防ぐため、実際には使用されていない参照を特定し、整理することは重要な保守作業である。本ダイアログは、未使用参照の分析結果をテーブル形式で表示し、開発者が削除対象を確認・選択してプロジェクトから削除できるようにする。

**画面へのアクセス方法**：
1. ソリューションエクスプローラーでプロジェクトを右クリック
2. コンテキストメニューから「未使用参照の削除」を選択
3. 未使用参照の分析が実行され、結果がダイアログに表示される

**主要な操作・処理内容**：
1. 未使用参照一覧表示：分析結果をテーブル形式で表示
2. 削除対象選択：各参照に対するアクション（Keep/Remove）を選択
3. 適用：選択した削除アクションをプロジェクトに適用
4. キャンセル：変更を破棄してダイアログを閉じる

**画面遷移**：
- 遷移元：ソリューションエクスプローラーのコンテキストメニュー
- 遷移先：なし（ダイアログ閉じる）

**権限による表示制御**：
特別な権限制御はなし。プロジェクトへの書き込み権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 68 | 未使用参照検出 | 主機能 | 未使用プロジェクト・パッケージ参照の一覧表示と削除操作 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

N/A（Visual Studioモーダルダイアログとして実装）

## 入出力項目

### 入力（コンストラクタパラメータ）

| 項目名 | 型 | 説明 |
|--------|------|------|
| tableProvider | UnusedReferencesTableProvider | テーブルコントロールプロバイダー |

### ShowModalパラメータ

| 項目名 | 型 | 説明 |
|--------|------|------|
| joinableTaskFactory | JoinableTaskFactory | UI同期用ファクトリ |
| solution | Solution | 対象ソリューション |
| projectFilePath | string | 対象プロジェクトファイルパス |
| referenceUpdates | ImmutableArray&lt;ReferenceUpdate&gt; | 参照更新情報 |

### 出力（表示）

| 項目名 | 型 | 説明 |
|--------|------|------|
| DialogResult | bool? | ダイアログ結果（true=適用、false/null=キャンセル） |

## 表示項目

### ダイアログヘッダー

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| ダイアログタイトル | Window.Title | RemoveUnusedReferences | "Remove Unused References" |

### ヘルプテキスト（Grid.Row="0"）

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| ガイダンステキスト | TextBlock | HelpText | 操作説明テキスト |

### テーブルパネル（Grid.Row="1"）

| 項目名 | コントロール | バインディング | 説明 |
|--------|-------------|---------------|------|
| 未使用参照テーブル | Border (TablePanel) | Child（動的設定） | 未使用参照一覧テーブル |

### ボタンパネル（Grid.Row="2"）

| 項目名 | コントロール | イベント | 説明 |
|--------|-------------|---------|------|
| 適用ボタン | Button (ApplyButton) | ApplyButton_Click | "Apply"を表示、変更を適用 |
| キャンセルボタン | Button (CancelButton) | IsCancel=True | "Cancel"を表示、変更を破棄 |

## イベント仕様

### 1-ダイアログ表示（ShowModal）

1. `ShowModal`メソッドが呼び出される
2. `_tableProvider.AddTableData`で未使用参照データを設定
3. `_tableProvider.CreateTableControl`でテーブルコントロールを作成
4. `TablePanel.Child`にテーブルコントロールを設定
5. `joinableTaskFactory.Run(tableControl.ForceUpdateAsync)`でテーブルを更新
6. `ShowModal()`でモーダルダイアログを表示
7. ダイアログ終了後、`TablePanel.Child = null`でコントロールを解除
8. `_tableProvider.ClearTableData()`でデータをクリア（メモリリーク防止）

### 2-適用ボタンクリック（ApplyButton_Click）

1. `ApplyButton`押下
2. `ApplyButton_Click`ハンドラが発生
3. `DialogResult = true`を設定
4. `Close()`でダイアログを閉じる
5. 呼び出し元で`DialogResult`を確認し、trueの場合は参照削除を実行

### 3-キャンセルボタンクリック

1. `CancelButton`押下（または`Escape`キー）
2. `IsCancel="True"`により自動的にダイアログが閉じる
3. `DialogResult = false`または`null`

## データベース更新仕様

N/A（本ダイアログはデータベースとの直接的なやり取りは行わない。プロジェクトファイルの更新は呼び出し元で行われる）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|---------------|----------------|
| RemoveUnusedReferences | タイトル | "Remove Unused References" | ダイアログタイトル |
| HelpText | ガイダンス | "Choose which action you would like to perform on the unused references" | ヘルプテキスト |
| Apply | ボタン | "Apply" | 適用ボタンラベル |
| Cancel | ボタン | "Cancel" | キャンセルボタンラベル |

## 例外処理

| 例外ケース | 対処 |
|-----------|------|
| テーブルデータ設定失敗 | finallyブロックでClearTableDataを実行してメモリリーク防止 |
| テーブル更新失敗 | JoinableTaskFactoryで同期的に処理、エラーは上位に伝播 |

## 備考

- DialogWindowクラスを継承したVS標準ダイアログ
- テーブルコントロールはUnusedReferencesTableProviderから動的に生成
- テーブルはバックグラウンドスレッドで更新されるため、ForceUpdateAsyncで同期
- ダイアログサイズは450x600ピクセル（固定）
- WindowStartupLocation="CenterOwner"で親ウィンドウ中央に表示
- ShowInTaskbar="False"でタスクバーに表示しない
- VsResourceKeysでテーマ対応のスタイルを適用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

未使用参照のデータモデルとテーブルプロバイダーの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReferenceUpdate.cs | `src/Workspaces/Core/Portable/UnusedReferences/ReferenceUpdate.cs` | 参照更新情報（アクション、参照情報） |
| 1-2 | UnusedReferencesTableProvider.cs | `src/VisualStudio/Core/Def/UnusedReferences/UnusedReferencesTableProvider.cs` | テーブルデータ管理、テーブルコントロール生成 |

**読解のコツ**:
- `ReferenceUpdate`は参照に対するアクション（Keep/Remove）を保持
- `UnusedReferencesTableProvider`はITableDataSourceを実装し、VSテーブルと連携

#### Step 2: エントリーポイントを理解する

ダイアログのXAML定義とコードビハインドで構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RemoveUnusedReferencesDialog.xaml | `src/VisualStudio/Core/Def/UnusedReferences/Dialog/RemoveUnusedReferencesDialog.xaml` | 3行Gridレイアウト、テーブルパネル、ボタン配置 |
| 2-2 | RemoveUnusedReferencesDialog.xaml.cs | `src/VisualStudio/Core/Def/UnusedReferences/Dialog/RemoveUnusedReferencesDialog.xaml.cs` | ShowModal処理、ApplyButton_Click |

**主要処理フロー**:
1. **行19-22**: プロパティでローカライズ文字列を公開
2. **行26-32**: コンストラクタでtableProviderを保持
3. **行34-60**: ShowModalでテーブル表示と結果返却
4. **行40-47**: テーブルコントロールの作成と設定
5. **行62-66**: ApplyButton_ClickでDialogResult設定とClose

### プログラム呼び出し階層図

```
RemoveUnusedReferencesDialog (DialogWindow)
    │
    ├─ コンストラクタ
    │      └─ _tableProvider を保持
    │
    ├─ ShowModal(joinableTaskFactory, solution, projectFilePath, referenceUpdates)
    │      ├─ _tableProvider.AddTableData(solution, projectFilePath, referenceUpdates)
    │      │      └─ テーブルデータソースにデータを追加
    │      │
    │      ├─ _tableProvider.CreateTableControl()
    │      │      └─ IWpfTableControlを生成
    │      │
    │      ├─ TablePanel.Child = tableControl.Control
    │      │      └─ UIにテーブルを配置
    │      │
    │      ├─ joinableTaskFactory.Run(tableControl.ForceUpdateAsync)
    │      │      └─ バックグラウンド更新を同期待機
    │      │
    │      ├─ ShowModal() ─────────────────▶ ダイアログ表示
    │      │
    │      └─ finally
    │             ├─ TablePanel.Child = null
    │             └─ _tableProvider.ClearTableData()
    │
    └─ ApplyButton_Click(sender, e)
           ├─ DialogResult = true
           └─ Close()
```

### データフロー図

```
[入力]                      [処理]                            [出力]

referenceUpdates ─────────▶ AddTableData() ─────────────────▶ テーブルデータソース
      │
      ▼
CreateTableControl() ─────▶ IWpfTableControl
      │
      ▼
ForceUpdateAsync() ───────▶ テーブル表示更新
      │
      ▼
ShowModal() ──────────────▶ ユーザー操作待機
      │
      ├─ Apply押下
      │      ▼
      │   DialogResult = true ───────────────▶ 参照削除処理（呼び出し元）
      │
      └─ Cancel押下
             ▼
          DialogResult = false/null ─────────▶ 処理中止
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RemoveUnusedReferencesDialog.xaml | `src/VisualStudio/Core/Def/UnusedReferences/Dialog/RemoveUnusedReferencesDialog.xaml` | XAML | UI定義 |
| RemoveUnusedReferencesDialog.xaml.cs | `src/VisualStudio/Core/Def/UnusedReferences/Dialog/RemoveUnusedReferencesDialog.xaml.cs` | ソース | コードビハインド |
| UnusedReferencesTableProvider.cs | `src/VisualStudio/Core/Def/UnusedReferences/UnusedReferencesTableProvider.cs` | ソース | テーブルデータプロバイダー |
| ReferenceUpdate.cs | `src/Workspaces/Core/Portable/UnusedReferences/ReferenceUpdate.cs` | ソース | 参照更新データモデル |
| RemoveUnusedReferencesCommandHandler.cs | `src/VisualStudio/Core/Def/UnusedReferences/RemoveUnusedReferencesCommandHandler.cs` | ソース | コマンドハンドラ（ダイアログ呼び出し元） |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
| EditorFeaturesResources.resx | `src/EditorFeatures/Core/EditorFeaturesResources.resx` | リソース | エディタ機能ローカライズ文字列 |
