# 画面設計書 2-パラメータ追加ダイアログ

## 概要

本ドキュメントは、シグネチャ変更ダイアログから呼び出される、新規パラメータを追加するためのサブダイアログ画面の設計仕様を記述する。

### 本画面の処理概要

パラメータ追加ダイアログは、メソッドシグネチャに新しいパラメータを追加するための入力フォームを提供する画面である。

**業務上の目的・背景**：メソッドの機能拡張時、既存のパラメータ構成に新しいパラメータを追加する必要がある。本ダイアログは、型名、パラメータ名、必須/オプション属性、呼び出し元での値の挿入方法など、パラメータに関する全ての情報を一括で設定できるインターフェースを提供する。

**画面へのアクセス方法**：シグネチャ変更ダイアログの「Add」ボタンをクリックして表示する。

**主要な操作・処理内容**：
1. 型名の入力（リアルタイムバリデーション付き）
2. パラメータ名の入力
3. パラメータ種別の選択（必須/オプション）
4. オプションパラメータの場合のデフォルト値入力
5. 呼び出し元での値挿入方法の選択
   - 値を直接指定
   - 名前付き引数を使用
   - TODO変数を挿入
   - コンテキストから推論
   - 省略（オプションパラメータのみ）
6. OKボタンで確定、Cancelボタンでキャンセル

**画面遷移**：
- 遷移元：シグネチャ変更ダイアログ（Addボタン）
- 遷移先：なし
- 戻り先：シグネチャ変更ダイアログ（OK/Cancel時）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | シグネチャ変更 | 主機能 | 新しいパラメータ情報の入力と追加処理 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

該当なし（Visual Studio IDEのWPFダイアログとして実装）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| VerbatimTypeName | 入力 | string | Yes | 入力された型名（そのまま） |
| TypeSymbol | 出力 | ITypeSymbol? | No | 解決された型シンボル |
| ParameterName | 入出力 | string | Yes | パラメータ名 |
| IsRequired | 入出力 | bool | Yes | 必須パラメータかどうか |
| DefaultValue | 入出力 | string | No | オプションパラメータのデフォルト値 |
| CallSiteValue | 入出力 | string | No | 呼び出し元で挿入する値 |
| UseNamedArguments | 入出力 | bool | No | 名前付き引数を使用するか |
| IsCallsiteTodo | 入出力 | bool | No | TODO変数を挿入するか |
| IsCallsiteInferred | 入出力 | bool | No | コンテキストから推論するか |
| IsCallsiteOmitted | 入出力 | bool | No | 呼び出し元で省略するか |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|----------|------|
| 型名入力欄 | VerbatimTypeName | TextBox | 型名の入力 |
| 型バインド状態アイコン | TypeBindsImage等 | CrispImage | 型解決状態を示すアイコン |
| 型バインド状態テキスト | TypeBindsDynamicStatus | LiveTextBlock | 型解決状態の説明 |
| パラメータ名入力欄 | ParameterName | TextBox | パラメータ名の入力 |
| 必須ラジオボタン | IsRequired | RadioButton | 必須パラメータ選択 |
| オプションラジオボタン | IsOptional | RadioButton | オプションパラメータ選択 |
| デフォルト値入力欄 | DefaultValue | TextBox | デフォルト値（オプション時のみ有効） |

## イベント仕様

### 1-型名入力変更

型名が入力されるたびにリアルタイムでバリデーションを実行。型の解決状態に応じて4種類のアイコンを表示：
- 情報アイコン：未入力状態
- エラーアイコン：構文エラーまたは無効な型
- OKアイコン：型が正常に解決
- 警告アイコン：型は解析可能だがバインドしない

### 2-パラメータ種別変更

必須/オプションのラジオボタン切り替え時：
- 必須選択時：デフォルト値入力欄を無効化、「省略」オプションを無効化
- オプション選択時：デフォルト値入力欄を有効化、「省略」オプションを有効化

### 3-呼び出し元値挿入方法選択

ラジオボタンで以下のオプションから選択：
- Value：値を直接入力
- Use named argument：名前付き引数として挿入
- Introduce TODO variables：未定義のTODO変数を挿入
- Infer from context：コンテキストから推論
- Omit：省略（オプションパラメータのみ）

### 4-OK確定

入力内容のバリデーションを実行：
- 型名とパラメータ名が入力されているか
- System.Voidでないか
- 型構文が有効か
- パラメータ名が有効な識別子か
- 呼び出し元値が設定されているか（Value選択時）
- デフォルト値が設定されているか（オプション選択時）

バリデーション成功時はDialogResult=trueで閉じる。

### 5-キャンセル

DialogResult=falseでダイアログを閉じる。

## データベース更新仕様

該当なし（データベースアクセスなし）

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|----------------|----------|
| 情報 | MSG_ENTER_TYPE | 型名を入力してください | 型名未入力時 |
| 情報 | MSG_TYPE_RECOGNIZED | 型名が認識されました | 型が正常解決時 |
| 警告 | MSG_TYPE_NOT_RECOGNIZED | 型名が認識されません | 型がバインドしない時 |
| エラー | MSG_SYNTAX_ERROR | 型名に構文エラーがあります | 構文エラー時 |
| エラー | MSG_VOID_INVALID | System.Voidはパラメータ型として無効です | void型入力時 |
| エラー | MSG_TYPE_NAME_REQUIRED | 型とパラメータ名を指定してください | 必須項目未入力時 |
| エラー | MSG_CALLSITE_VALUE_REQUIRED | 呼び出し元の値を入力するか、別の値挿入方法を選択してください | Value選択時に値未入力 |
| エラー | MSG_DEFAULT_VALUE_REQUIRED | オプションパラメータにはデフォルト値が必要です | オプション選択時にデフォルト値未入力 |

## 例外処理

| 状態 | 対応 |
|------|------|
| 型解決失敗 | 警告アイコンを表示し、追加は許可（呼び出し元で要修正） |
| 無効な識別子 | エラーメッセージを表示しOKを無効化 |

## 備考

- SizeToContent="Height"で高さは内容に合わせて自動調整
- 最小幅600px、リサイズ可能
- WPFバグ回避のためOnClosedでDataContextをnullに設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

追加されるパラメータの情報構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AddedParameter.cs | `src/Features/Core/Portable/ChangeSignature/AddedParameter.cs` | 追加パラメータを表すデータクラス |
| 1-2 | CallSiteKind.cs | `src/Features/Core/Portable/ChangeSignature/CallSiteKind.cs` | 呼び出し元での値挿入方法の列挙型 |

**読解のコツ**: AddedParameterはTypeSymbol、TypeName、ParameterName、CallSiteKind、CallSiteValue、IsRequired、DefaultValueを保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AddParameterDialog.xaml.cs | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml.cs` | ダイアログのコードビハインド |
| 2-2 | AddParameterDialogViewModel.cs | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialogViewModel.cs` | バリデーションロジックを含むViewModel |

**主要処理フロー**:
1. **行36-43**: コンストラクタで初期状態を設定
2. **行105-115**: VerbatimTypeNameプロパティのセッターで型バインドチェックを開始
3. **行177-232**: SetCurrentTypeTextAndUpdateBindingStatusで型解決とステータス更新
4. **行119-159**: CanSubmitで全入力項目のバリデーション
5. **行161-170**: TrySubmitでバリデーション実行と結果返却

#### Step 3: UI定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AddParameterDialog.xaml | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml` | 3つのGroupBoxによる構成 |

**主要処理フロー**:
- **行34-65**: Parameter information GroupBox（型・名前入力）
- **行66-92**: Parameter kind GroupBox（必須/オプション選択）
- **行93-139**: Value to inject at callsites GroupBox（呼び出し元値設定）

#### Step 4: 親ダイアログとの連携

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ChangeSignatureDialog.xaml.cs | `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml.cs` | Add_Clickでサブダイアログ呼び出し |

**主要処理フロー**:
- **行157-183**: Add_Clickでダイアログ表示、結果をAddedParameterに変換してViewModelに追加

### プログラム呼び出し階層図

```
ChangeSignatureDialog.Add_Click
    │
    └─ AddParameterDialog (モーダル表示)
           │
           ├─ AddParameterDialogViewModel
           │      ├─ VerbatimTypeName setter → SetCurrentTypeTextAndUpdateBindingStatus
           │      │      └─ SemanticModel.GetSpeculativeTypeInfo (型解決)
           │      │
           │      ├─ CanSubmit (バリデーション)
           │      │      ├─ IsParameterTypeSyntacticallyValid
           │      │      └─ IsParameterNameValid
           │      │
           │      └─ TrySubmit → 結果返却
           │
           └─ AddedParameter (生成されたパラメータ情報)
                  └─ ChangeSignatureDialogViewModel.AddParameter
```

### データフロー図

```
[入力]                    [処理]                         [出力]

型名テキスト ──────▶ SemanticModel.GetSpeculativeTypeInfo ──▶ TypeSymbol
                            │
パラメータ名 ─────▶ ISyntaxFactsService.IsValidIdentifier ──▶ 検証結果
                            │
種別・呼び出し元値 ────────────────────────────────────────▶ AddedParameter
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AddParameterDialog.xaml | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml` | XAML | ダイアログUI定義 |
| AddParameterDialog.xaml.cs | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml.cs` | ソース | コードビハインド |
| AddParameterDialogViewModel.cs | `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialogViewModel.cs` | ソース | ViewModel・バリデーション |
| AddedParameter.cs | `src/Features/Core/Portable/ChangeSignature/AddedParameter.cs` | ソース | 追加パラメータデータ |
| CallSiteKind.cs | `src/Features/Core/Portable/ChangeSignature/CallSiteKind.cs` | ソース | 呼び出し元値挿入種別 |
| IChangeSignatureViewModelFactoryService.cs | `src/EditorFeatures/Core/ChangeSignature/IChangeSignatureViewModelFactoryService.cs` | ソース | 言語固有の型検証サービス |
| ServicesVSResources.resx | `src/VisualStudio/Core/Def/ServicesVSResources.resx` | リソース | ローカライズ文字列 |
