# 画面設計書 21-リネームフライアウト

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるインラインリネーム機能のフライアウトUI（RenameFlyout）の設計を定義する。

### 本画面の処理概要

リネームフライアウトは、エディタ内でシンボルの名前変更を行う際に表示されるフローティングUIコントロールである。ユーザーがF2キーを押下するか、コンテキストメニューから「名前変更」を選択すると、カーソル位置のシンボル近くにこのフライアウトが表示され、新しい名前の入力と各種オプションの設定が可能となる。

**業務上の目的・背景**：コードリファクタリングにおいて、シンボルの名前変更は最も頻繁に行われる操作の一つである。従来のダイアログベースのリネームUIでは、エディタから視線を離す必要があり作業効率が低下していた。本フライアウトUIにより、ユーザーはエディタ内でシームレスにリネーム操作を完了でき、開発効率が大幅に向上する。また、Copilot連携によるスマートリネーム機能により、AI支援による命名候補の提示も可能となっている。

**画面へのアクセス方法**：
- エディタ内でシンボル上にカーソルを置き、F2キーを押下
- シンボルを右クリックし、コンテキストメニューから「名前変更(M)」を選択
- メニューバーから「編集」→「リファクタリング」→「名前変更」を選択

**主要な操作・処理内容**：
1. 新しい識別子名の入力（テキストボックスまたはスマートリネームコンボボックス）
2. リネームオプションの設定（オーバーロードの包含、コメント・文字列内の検索、ファイル名変更）
3. Enterキーによるリネーム確定
4. Shift+Enterキーによる変更プレビュー表示後の確定
5. Escapeキーによるリネーム操作のキャンセル
6. Ctrl+Spaceによるスマートリネーム候補の取得（Copilot有効時）

**画面遷移**：
- 遷移元: エディタビュー（F2キー押下時）
- 遷移先: なし（フライアウトはエディタ内に表示されるアドーメント）
- Enter押下後: エディタビューに戻る（リネーム完了）
- Escape押下後: エディタビューに戻る（リネームキャンセル）

**権限による表示制御**：特になし（エディタでシンボルが編集可能であれば表示可能）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | 名前変更 (Rename) | 主機能 | エディタ内でのインラインリネーム入力とオプション設定 |
| 124 | Copilot連携 | 補助機能 | SmartRename機能によるAI支援リネーム候補の表示 |

## 画面種別

編集（インラインアドーメント）

## URL/ルーティング

該当なし（Visual Studioエディタ内のアドーメントとして表示）

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 説明 |
|--------|--------|---------|----------|------|------|
| 識別子テキスト | IdentifierText | string | 入力 | 必須 | 新しいシンボル名 |
| オーバーロード含む | RenameOverloadsFlag | bool | 入力 | 任意 | メソッドのオーバーロードも同時にリネーム |
| コメント内検索 | RenameInCommentsFlag | bool | 入力 | 任意 | コメント内のシンボル参照もリネーム |
| 文字列内検索 | RenameInStringsFlag | bool | 入力 | 任意 | 文字列リテラル内のシンボル参照もリネーム |
| ファイル名変更 | RenameFileFlag | bool | 入力 | 任意 | 型名に一致するファイル名もリネーム |
| 変更プレビュー | PreviewChangesFlag | bool | 入力 | 任意 | リネーム確定前に変更プレビューを表示 |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| ステータステキスト | StatusText | テキスト | リネーム結果のステータス（警告・エラー情報） |
| ステータスアイコン | StatusImageMoniker | アイコン | エラー/警告アイコン |
| 検索テキスト | SearchText | テキスト | 「N件の参照をM個のファイルで更新します」等の情報 |
| 展開/折りたたみボタン | IsCollapsed | ボタン | オプション領域の展開/折りたたみ切替 |
| 送信テキスト | SubmitText | テキスト | 「Enterでリネーム、Shift+Enterでプレビュー」等のヒント |

## イベント仕様

### 1-Enterキー押下

リネーム操作を確定し、すべての参照箇所を新しい名前に更新する。

処理フロー:
1. StatusSeverityがErrorでないことを確認
2. SmartRenameViewModelがある場合、Commitを呼び出し
3. Session.CommitAsync()を非同期で実行
4. エディタにフォーカスを戻す

### 2-Escapeキー押下

リネーム操作をキャンセルし、元の状態に戻す。

処理フロー:
1. SmartRenameViewModelがある場合、Cancelを呼び出し
2. Session.Cancel()を実行
3. エディタにフォーカスを戻す

### 3-Ctrl+Space押下

スマートリネーム（Copilot連携）の候補取得をトグルまたはトリガーする。

処理フロー:
1. SmartRenameViewModelの存在確認
2. ToggleOrTriggerSuggestions()を呼び出し
3. 自動モードの場合は有効/無効を切替、明示モードの場合は候補取得開始

### 4-展開/折りたたみボタン押下

オプション領域の表示/非表示を切り替える。

処理フロー:
1. IsExpandedプロパティを反転
2. グローバルオプションにUIの折りたたみ状態を保存

## データベース更新仕様

該当なし（ソースコードファイルの更新のみ）

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| MSG001 | エラー | 無効な識別子名入力時 | "新しい名前は有効な識別子ではありません" |
| MSG002 | エラー | 解決不能な競合発生時 | "N件の解決できない競合があります" |
| MSG003 | 警告 | 解決可能な競合発生時 | "N件の競合は解決されます" |
| MSG004 | 情報 | 参照箇所検出時 | "N件の参照をM個のファイルで更新します" |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| シンボルがリネーム不可 | フライアウトは表示されない |
| 型名とファイル名が不一致 | ファイルリネームオプションが無効化され、説明テキストが表示される |
| 複数ファイルに分散する部分型 | ファイルリネームオプションが無効化され、説明テキストが表示される |

## 備考

- フライアウトの位置はシンボルの下に自動配置され、ビューポートからはみ出る場合は調整される
- スマートリネーム機能はCopilotが利用可能な場合のみ表示される
- UIの展開状態はグローバル設定として保存され、次回起動時に復元される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、リネームセッションとViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RenameFlyoutViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyoutViewModel.cs` | ViewModelのプロパティとINotifyPropertyChanged実装 |
| 1-2 | InlineRenameSession.cs | `src/EditorFeatures/Core/InlineRename/InlineRenameSession.cs` | リネームセッションの状態管理 |
| 1-3 | IRenameUserInput.cs | `src/EditorFeatures/Core/InlineRename/UI/IRenameUserInput.cs` | 入力コントロールの抽象化インターフェース |

**読解のコツ**: WPFのMVVMパターンに従っており、ViewModelがINotifyPropertyChangedを実装してUIとデータバインディングを行っている。

#### Step 2: エントリーポイントを理解する

処理の起点となるフライアウトの初期化処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RenameFlyout.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` | コンストラクタでの初期化処理とイベントハンドラ登録 |

**主要処理フロー**:
1. **行33-90**: コンストラクタでViewModelの設定、入力コントロールの選択（通常/スマートリネーム）
2. **行177-205**: Adornment_KeyDownでEnter/Escape/Ctrl+Spaceの処理
3. **行160-170**: Disposeでクリーンアップ処理

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RenameFlyout.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml` | Border、StackPanel、CheckBox等のUI構造 |

**主要処理フロー**:
- **行33-38**: 外枠のBorder定義（VS Shellテーマカラー使用）
- **行39-101**: 識別子入力と展開ボタンのGrid
- **行121-136**: オプションチェックボックス群

#### Step 4: スマートリネーム連携を理解する

Copilot連携によるAI支援リネーム機能を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SmartRenameViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` | AI候補取得とObservableCollection管理 |

**主要処理フロー**:
- **行175-188**: FetchSuggestionsでの候補取得開始
- **行287-302**: ScrollSuggestionsでの上下キー操作

### プログラム呼び出し階層図

```
InlineRenameAdornmentManager.CreateAdornment()
    │
    ├─ RenameFlyout (コンストラクタ)
    │      ├─ RenameFlyoutViewModel
    │      │      └─ SmartRenameViewModel (Copilot有効時)
    │      ├─ RenameUserInputTextBox または SmartRenameUserInputComboBox
    │      └─ SmartRenameStatusControl (Copilot有効時)
    │
    ├─ Adornment_KeyDown (キー入力処理)
    │      ├─ Submit() → Session.CommitAsync()
    │      ├─ Cancel() → Session.Cancel()
    │      └─ ToggleOrTriggerSuggestions()
    │
    └─ PositionAdornment (位置調整)
           └─ TextView座標計算
```

### データフロー図

```
[入力]                    [処理]                         [出力]

IdentifierText ───▶ RenameFlyoutViewModel ───▶ InlineRenameSession
    │                        │                         │
    │                        ▼                         ▼
    │              Session.ApplyReplacementText    ソースコード更新
    │
オプションフラグ ──▶ GlobalOptionService ───▶ 設定永続化
    │
    │
Copilot候補 ◀────── SmartRenameViewModel ◀──── ISmartRenameSession
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RenameFlyout.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml` | XAML | UI定義 |
| RenameFlyout.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` | ソース | コードビハインド |
| RenameFlyoutViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyoutViewModel.cs` | ソース | ViewModel |
| RenameUserInputTextBox.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml` | XAML | 標準入力コントロール |
| RenameUserInputTextBox.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml.cs` | ソース | 標準入力コントロールのコードビハインド |
| SmartRenameUserInputComboBox.xaml | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameUserInputComboBox.xaml` | XAML | スマートリネーム入力コントロール |
| SmartRenameViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` | ソース | スマートリネームViewModel |
| InlineRenameSession.cs | `src/EditorFeatures/Core/InlineRename/InlineRenameSession.cs` | ソース | リネームセッション管理 |
| InlineRenameColors.xaml | `src/EditorFeatures/Core/InlineRename/UI/InlineRenameColors.xaml` | XAML | カラーリソース定義 |
| IRenameUserInput.cs | `src/EditorFeatures/Core/InlineRename/UI/IRenameUserInput.cs` | ソース | 入力インターフェース |
