# 画面設計書 22-リネームユーザー入力テキストボックス

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるインラインリネーム機能の標準テキスト入力コントロール（RenameUserInputTextBox）の設計を定義する。

### 本画面の処理概要

リネームユーザー入力テキストボックスは、リネームフライアウト内でユーザーが新しいシンボル名を入力するための標準的なテキストボックスコントロールである。Copilot連携（スマートリネーム）が無効な環境では、このコントロールが入力UIとして使用される。

**業務上の目的・背景**：シンボルの名前変更において、ユーザーが新しい名前を入力するためのシンプルかつ効率的な入力手段を提供する。Visual Studioのテーマと統合されたスタイルを使用し、IDEの他のテキストボックスと一貫した操作感を実現している。

**画面へのアクセス方法**：
- リネームフライアウトが表示される際に、Copilot連携が無効な場合に自動的にこのコントロールが使用される
- 親コントロールであるRenameFlyoutのRenameUserInputPresenterにコンテンツとして配置される

**主要な操作・処理内容**：
1. 新しい識別子名のテキスト入力
2. テキスト選択操作（SelectAll、Select）
3. テキスト選択変更イベントの発火
4. キーボードフォーカスの受け取り

**画面遷移**：
- このコントロール単体での画面遷移はなし
- 親コントロール（RenameFlyout）の一部として動作

**権限による表示制御**：特になし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | 名前変更 (Rename) | 補助機能 | リネーム名入力のテキストボックスコンポーネント |

## 画面種別

入力コントロール（RenameFlyoutの子コントロール）

## URL/ルーティング

該当なし（Visual Studioエディタ内のコントロールとして表示）

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 説明 |
|--------|--------|---------|----------|------|------|
| 識別子テキスト | IdentifierText | string | 入力/出力 | 必須 | 新しいシンボル名（ViewModelとTwoWayバインディング） |
| テキスト選択開始位置 | TextSelectionStart | int | 出力 | - | 選択範囲の開始位置 |
| テキスト選択長 | TextSelectionLength | int | 出力 | - | 選択範囲の長さ |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| テキスト内容 | IdentifierText | テキストボックス | 入力された識別子名 |

## イベント仕様

### 1-TextSelectionChanged

テキストの選択状態が変更された際に発火するイベント。

処理フロー:
1. SelectionChangedEventをハンドル
2. 親コントロール（RenameFlyout）に選択変更を通知
3. エディタ上の対応する位置の選択を同期

### 2-PreviewKeyDown

キー押下時のプレビューイベント。

処理フロー:
1. 親コントロールのキーハンドラに処理を委譲
2. 上下キーでスマートリネーム候補のスクロール（スマートリネーム有効時のみ）

### 3-Focus

コントロールへのフォーカス設定。

処理フロー:
1. TextBoxのFocusメソッドを呼び出し
2. キーボードフォーカスを取得

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし（親コントロールがメッセージを処理）

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 無効な識別子入力 | 親コントロール（RenameFlyoutViewModel）がバリデーションを実施 |

## 備考

- Visual Studioのテーマに対応したスタイル（VsResourceKeys.TextBoxStyleKey）を使用
- IRenameUserInputインターフェースを実装し、親コントロールから統一的に操作可能
- PropertyChangedでUpdateSourceTriggerを使用し、リアルタイムで入力をViewModelに反映

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、入力コントロールのインターフェースを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IRenameUserInput.cs | `src/EditorFeatures/Core/InlineRename/UI/IRenameUserInput.cs` | 入力コントロールが実装すべきインターフェース定義 |

**読解のコツ**: このインターフェースは、通常のテキストボックスとスマートリネームコンボボックスの両方で実装され、親コントロールから統一的に操作できるようにしている。

#### Step 2: エントリーポイントを理解する

コントロールの初期化と基本動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RenameUserInputTextBox.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml.cs` | コンストラクタとインターフェース実装 |

**主要処理フロー**:
1. **行16-20**: コンストラクタでViewModelをDataContextに設定
2. **行22-32**: TextSelectionStart/TextSelectionLengthプロパティの実装
3. **行58-66**: SelectText/SelectAllTextメソッドの実装

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RenameUserInputTextBox.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml` | TextBoxのスタイルとデータバインディング |

**主要処理フロー**:
- **行9**: VsResourceKeys.TextBoxStyleKeyによるVSテーマ統合
- **行10**: IdentifierTextプロパティへのTwoWayバインディング

### プログラム呼び出し階層図

```
RenameFlyout (コンストラクタ)
    │
    └─ RenameUserInputTextBox (生成)
           │
           ├─ InitializeComponent()
           │      └─ XAMLパース・バインディング設定
           │
           ├─ IRenameUserInput.Focus()
           │      └─ TextBox.Focus()
           │
           ├─ IRenameUserInput.SelectText()
           │      └─ TextBox.Select()
           │
           └─ TextSelectionChanged (イベント)
                  └─ RenameFlyout.RenameUserInput_TextSelectionChanged()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

キーボード入力 ───▶ RenameUserInputTextBox ───▶ IdentifierText
    │                        │                    (TwoWayBinding)
    │                        ▼                         │
    │              Text プロパティ変更                 ▼
    │                        │              RenameFlyoutViewModel
    │                        ▼                         │
    │              UpdateSourceTrigger                 ▼
    │              =PropertyChanged            Session.ApplyReplacementText()
    │
    │
選択変更 ──────▶ SelectionChangedEvent ───▶ RenameFlyout (親)
                                                       │
                                                       ▼
                                               TextView選択同期
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RenameUserInputTextBox.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml` | XAML | UI定義 |
| RenameUserInputTextBox.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml.cs` | ソース | コードビハインド |
| IRenameUserInput.cs | `src/EditorFeatures/Core/InlineRename/UI/IRenameUserInput.cs` | ソース | 入力インターフェース |
| RenameFlyout.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml` | XAML | 親コントロール |
| RenameFlyout.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` | ソース | 親コントロールのコードビハインド |
| RenameFlyoutViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyoutViewModel.cs` | ソース | ViewModel |
