# 画面設計書 23-インラインリネームカラー定義

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるインラインリネーム機能のカラーリソース定義（InlineRenameColors.xaml）の設計を定義する。

### 本画面の処理概要

インラインリネームカラー定義は、リネームフライアウトUIで使用されるデフォルトカラーを定義するリソースディクショナリである。これはUI画面ではなく、リソースファイルとして他のXAMLファイルから参照される。Visual Studio等のホスト環境がこれらのカラーを上書きすることで、テーマに応じた外観の統一を実現する。

**業務上の目的・背景**：Visual Studioは複数のテーマ（Light、Dark、Blue等）をサポートしており、拡張機能のUIもこれらのテーマに対応する必要がある。このリソースディクショナリはデフォルトカラーを提供し、ホスト環境がテーマに応じてこれらを上書きできるようにしている。これにより、インラインリネームUIがどのテーマでも適切に表示される。

**画面へのアクセス方法**：
- このファイル自体は画面ではなく、他のXAMLファイルからリソースとして参照される
- InlineRenameColors.csと連携して、ホストがカラーを上書きする

**主要な操作・処理内容**：
1. デフォルトカラーブラシの定義
2. ボタンスタイルのデフォルト定義
3. ホスト環境からの上書きポイントの提供

**画面遷移**：該当なし（リソースディクショナリ）

**権限による表示制御**：該当なし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | 名前変更 (Rename) | 補助機能 | インラインリネームUIの色定義リソース |

## 画面種別

リソースディクショナリ（画面ではない）

## URL/ルーティング

該当なし

## 入出力項目

該当なし（リソース定義のみ）

## 表示項目

該当なし（リソース定義のみ）

## リソース定義

| リソースキー | リソース型 | デフォルト値 | 説明 |
|-------------|-----------|-------------|------|
| SystemCaptionTextColor | Color | Black | システムキャプションテキストカラー |
| SystemCaptionTextBrush | SolidColorBrush | Black | システムキャプションテキストブラシ |
| CheckBoxTextBrush | SolidColorBrush | Black | チェックボックステキストブラシ |
| BackgroundBrush | SolidColorBrush | LightGray | 背景ブラシ |
| AccentBarBrush | SolidColorBrush | Blue | アクセントバーブラシ |
| ButtonBorderBrush | SolidColorBrush | White | ボタンボーダーブラシ |
| GrayTextBrush | SolidColorBrush | Gray | グレーテキストブラシ |
| TextBoxTextBrushKey | SolidColorBrush | Black | テキストボックスのテキストブラシ |
| TextBoxBackgroundBrushKey | SolidColorBrush | White | テキストボックスの背景ブラシ |
| TextBoxBorderBrushKey | SolidColorBrush | Black | テキストボックスのボーダーブラシ |
| ButtonStyle | Style (Button) | デフォルトボタンスタイル | ボタンのスタイル定義 |

## イベント仕様

該当なし

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし

## 例外処理

該当なし

## 備考

- このファイルはVisual Studio以外の環境（テスト環境等）でのフォールバック値を提供
- Visual Studioでホストされる場合、InlineRenameColors.csにより定義されたカラーが上書きされる
- InlineRenameColors.csではIInlineRenameColorUpdaterを通じてテーマ変更に対応

---

## コードリーディングガイド

本リソースを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リソース定義を理解する

まず、XAMLで定義されているリソースを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InlineRenameColors.xaml | `src/EditorFeatures/Core/InlineRename/UI/InlineRenameColors.xaml` | デフォルトカラー定義 |

**読解のコツ**: 各リソースキーはInlineRenameColors.csで参照可能なキーとして定義されている。

#### Step 2: カラー上書きメカニズムを理解する

Visual StudioホストによるカラーのオーバーライドI機構を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InlineRenameColors.cs | `src/EditorFeatures/Core/InlineRename/UI/InlineRenameColors.cs` | カラーオーバーライドの実装 |
| 2-2 | IInlineRenameColorUpdater.cs | `src/EditorFeatures/Core/InlineRename/UI/IInlineRenameColorUpdater.cs` | カラー更新インターフェース |

**主要処理フロー**:
- InlineRenameColors.csでリソースキーを静的プロパティとして公開
- IInlineRenameColorUpdaterを通じてテーマ変更時にカラーを更新

### プログラム呼び出し階層図

```
ResourceDictionary (InlineRenameColors.xaml)
    │
    ├─ デフォルトカラー定義
    │      ├─ SystemCaptionTextColor/Brush
    │      ├─ CheckBoxTextBrush
    │      ├─ BackgroundBrush
    │      ├─ AccentBarBrush
    │      └─ TextBox関連ブラシ
    │
    └─ 参照元
           ├─ RenameFlyout.xaml (DynamicResource参照)
           └─ 旧ダッシュボードUI

InlineRenameColors.cs
    │
    ├─ リソースキーの静的プロパティ公開
    │
    └─ IInlineRenameColorUpdater
           └─ テーマ変更時のカラー更新
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テーマ設定 ───────▶ IInlineRenameColorUpdater ───▶ リソースディクショナリ更新
    │                        │                              │
    │                        ▼                              ▼
    │              カラーブラシ作成/更新                UI要素への反映
    │                                                  (DynamicResource)
    │
デフォルト値 ◀──── InlineRenameColors.xaml
  (フォールバック)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InlineRenameColors.xaml | `src/EditorFeatures/Core/InlineRename/UI/InlineRenameColors.xaml` | XAML | デフォルトカラーリソース定義 |
| InlineRenameColors.cs | `src/EditorFeatures/Core/InlineRename/UI/InlineRenameColors.cs` | ソース | カラーキー定義とオーバーライド |
| IInlineRenameColorUpdater.cs | `src/EditorFeatures/Core/InlineRename/UI/IInlineRenameColorUpdater.cs` | ソース | カラー更新インターフェース |
| RenameFlyout.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml` | XAML | カラーリソースの参照元 |
