# 画面設計書 24-スマートリネームユーザー入力コンボボックス

## 概要

本ドキュメントは、Visual StudioのRoslyn拡張機能におけるスマートリネーム機能のユーザー入力コンボボックス（SmartRenameUserInputComboBox）の設計を定義する。

### 本画面の処理概要

スマートリネームユーザー入力コンボボックスは、Copilot連携が有効な環境でリネームフライアウト内に表示される入力コントロールである。通常のテキスト入力に加えて、AIが生成したリネーム候補をドロップダウンリストとして表示し、ユーザーが候補から選択することができる。

**業務上の目的・背景**：シンボルの命名は開発者にとって重要かつ時間のかかる作業である。Copilot（AI）連携により、コンテキストを理解した適切な命名候補を提示することで、開発者の意思決定を支援し、命名品質の向上と作業効率化を実現する。スマートリネーム機能は、自動モードと明示モードの2つの動作モードをサポートし、ユーザーの好みに応じた操作が可能である。

**画面へのアクセス方法**：
- リネームフライアウトが表示される際に、Copilot連携が有効な場合に自動的にこのコントロールが使用される
- 親コントロールであるRenameFlyoutのRenameUserInputPresenterにコンテンツとして配置される

**主要な操作・処理内容**：
1. 新しい識別子名のテキスト入力（編集可能なコンボボックス）
2. AI候補の取得ボタン押下または自動取得
3. ドロップダウンリストからの候補選択
4. 上下キーによる候補スクロール
5. 候補選択時のテキスト反映
6. ダブルクリックによる即座のリネーム確定

**画面遷移**：
- このコントロール単体での画面遷移はなし
- 親コントロール（RenameFlyout）の一部として動作

**権限による表示制御**：
- Copilot連携が利用可能な場合のみこのコントロールが使用される
- Copilotが利用不可の場合は通常のテキストボックス（RenameUserInputTextBox）が使用される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | 名前変更 (Rename) | 主機能 | AI支援リネーム候補の選択と入力 |
| 124 | Copilot連携 | 主機能 | Copilotによるリネーム候補生成と表示 |

## 画面種別

入力コントロール（RenameFlyoutの子コントロール）

## URL/ルーティング

該当なし（Visual Studioエディタ内のコントロールとして表示）

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 説明 |
|--------|--------|---------|----------|------|------|
| 識別子テキスト | BaseViewModel.IdentifierText | string | 入力/出力 | 必須 | 新しいシンボル名 |
| 候補リスト | SuggestedNames | ObservableCollection<string> | 出力 | - | AI生成された候補名リスト |
| 選択された候補 | SelectedSuggestedName | string | 入力 | - | ユーザーが選択した候補名 |

## 表示項目

| 項目名 | データソース | 表示形式 | 説明 |
|--------|-------------|---------|------|
| テキスト入力 | Text | 編集可能テキスト | 入力/選択された識別子名 |
| 候補リスト | SuggestedNames | ドロップダウンリスト | AI生成された候補（最大3件） |
| 候補取得ボタン | GetSuggestionsButton | ボタン | 候補取得/トグルボタン |
| プログレスバー | ProgressBar | 進捗表示 | 候補取得中の読み込み表示 |
| 候補パネル | SuggestionsPanel | リストパネル | 候補表示領域 |

## イベント仕様

### 1-GetSuggestionsButtonClick

候補取得ボタンがクリックされた際の処理。

処理フロー:
1. SmartRenameViewModelのToggleOrTriggerSuggestions()を呼び出し
2. 自動モードの場合: 有効/無効をトグル
3. 明示モードの場合: 候補取得を開始
4. IsSuggestionsPanelExpandedとIsAutomaticSuggestionsEnabledを更新

### 2-ComboBox_SelectionChanged

ドロップダウンから候補が選択された際の処理。

処理フロー:
1. 選択されたアイテムを取得
2. SmartRenameViewModelのSelectedSuggestedNameに設定
3. BaseViewModelのIdentifierTextが自動的に更新される

### 3-SuggestionsPanelScrollViewer_MouseDoubleClick

候補パネル内でダブルクリックされた際の処理。

処理フロー:
1. BaseViewModelのSubmit()を呼び出し
2. リネーム操作が即座に確定される

### 4-SuggestedNames_CollectionChanged

候補リストの内容が変更された際の処理。

処理フロー:
1. ユーザーが選択を変更していない場合、フォーカスを維持
2. テキストボックスの全選択状態を維持

## データベース更新仕様

該当なし

## メッセージ仕様

該当なし（親コントロールがメッセージを処理）

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| Copilot接続エラー | SmartRenameStatusControlにエラーメッセージを表示 |
| 候補取得タイムアウト | プログレスバーが非表示になり、再試行可能 |

## 備考

- Visual Studioのテーマに対応したコンボボックススタイルを使用
- 候補は最大3件まで表示
- 自動モード/明示モードの設定はユーザー設定として永続化
- Copilotブランドカラー（#6F66E3）でプログレスバーを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スマートリネームのViewModelを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SmartRenameViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` | 候補管理とCopilot連携 |
| 1-2 | IRenameUserInput.cs | `src/EditorFeatures/Core/InlineRename/UI/IRenameUserInput.cs` | 入力コントロールの抽象化インターフェース |

**読解のコツ**: SmartRenameViewModelはINotifyPropertyChangedを実装し、SuggestedNamesをObservableCollectionとして管理している。IsInProgressプロパティで読み込み状態を制御している。

#### Step 2: エントリーポイントを理解する

コントロールの初期化と基本動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SmartRenameUserInputComboBox.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameUserInputComboBox.xaml.cs` | コンストラクタとイベントハンドラ |

**主要処理フロー**:
1. **行27-46**: コンストラクタでViewModelの設定とイベント登録
2. **行120-123**: GetSuggestionsButtonClickで候補取得をトリガー
3. **行130-137**: ComboBox_SelectionChangedで選択反映

#### Step 3: UI定義を理解する

XAMLによるUI構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SmartRenameUserInputComboBox.xaml | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameUserInputComboBox.xaml` | カスタムテンプレートの構造 |

**主要処理フロー**:
- **行29-57**: ComboBoxItemTemplateでハイライト表示を定義
- **行101-244**: ControlTemplateでテキストボックス、ボタン、プログレスバー、候補パネルを配置
- **行133-177**: GetSuggestionsButtonの定義とスパークルアイコン

### プログラム呼び出し階層図

```
RenameFlyout (コンストラクタ)
    │
    └─ SmartRenameUserInputComboBox (Copilot有効時に生成)
           │
           ├─ InitializeComponent()
           │      └─ カスタムComboBoxテンプレート適用
           │
           ├─ GetSuggestionsButtonClick()
           │      └─ SmartRenameViewModel.ToggleOrTriggerSuggestions()
           │             └─ ISmartRenameSession.GetSuggestionsAsync()
           │
           ├─ ComboBox_SelectionChanged()
           │      └─ SmartRenameViewModel.SelectedSuggestedName = 選択値
           │             └─ BaseViewModel.IdentifierText 更新
           │
           └─ SuggestedNames_CollectionChanged()
                  └─ Focus() (選択未変更時)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GetSuggestionsButton ──▶ SmartRenameViewModel ───▶ ISmartRenameSession
      押下                      │                         │
                               │                         ▼
                               │              Copilot API呼び出し
                               │                         │
                               ▼                         │
                        SuggestedNames ◀─────────────────┘
                               │
                               ▼
キーボード入力 ───▶ IdentifierText ───────▶ RenameFlyoutViewModel
    │
    │
候補選択 ─────────▶ SelectedSuggestedName ─▶ IdentifierText
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SmartRenameUserInputComboBox.xaml | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameUserInputComboBox.xaml` | XAML | UI定義 |
| SmartRenameUserInputComboBox.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameUserInputComboBox.xaml.cs` | ソース | コードビハインド |
| SmartRenameViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` | ソース | ViewModel |
| SmartRenameViewModel_Telemetry.cs | `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel_Telemetry.cs` | ソース | テレメトリ実装 |
| IRenameUserInput.cs | `src/EditorFeatures/Core/InlineRename/UI/IRenameUserInput.cs` | ソース | 入力インターフェース |
| RenameFlyout.xaml | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml` | XAML | 親コントロール |
| RenameFlyoutViewModel.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyoutViewModel.cs` | ソース | 親ViewModel |
